/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.nodemanager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.node.HashMapNode;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.node.TreeMapNode;
import top.chitucao.summerframework.trie.nodemanager.NodeManager;
import top.chitucao.summerframework.trie.query.Aggregation;
import top.chitucao.summerframework.trie.query.Criterion;

public class DefaultNodeManager<T, R>
implements NodeManager<T, R> {
    protected NodeManager<T, R> prev;
    protected NodeManager<T, R> next;
    protected Property<T, R> property;

    public DefaultNodeManager(Property<T, R> property) {
        this.property = property;
    }

    @Override
    public NodeManager<T, R> prev() {
        return this.prev;
    }

    @Override
    public NodeManager<T, R> next() {
        return this.next;
    }

    @Override
    public Property<T, R> property() {
        return this.property;
    }

    @Override
    public Node createNewNode() {
        switch (this.property.nodeType()) {
            case TREE_MAP: {
                return new TreeMapNode();
            }
        }
        return new HashMapNode();
    }

    @Override
    public Node createNewNode(Map<Number, Node> childMap) {
        switch (this.property.nodeType()) {
            case TREE_MAP: {
                return new TreeMapNode(childMap);
            }
        }
        return new HashMapNode(childMap);
    }

    @Override
    public Node createEmptyValueNode(Stream<Number> keys) {
        switch (this.property.nodeType()) {
            case TREE_MAP: {
                return new TreeMapNode(keys);
            }
        }
        return new HashMapNode(keys);
    }

    @Override
    public Stream<R> mappingDictValues(Set<Number> dictKeys) {
        return dictKeys.stream().map(dictKey -> this.property.dict().getDictValue((Number)dictKey));
    }

    @Override
    public Number mappingDictKey(T t) {
        return this.property.dict().getDictKey(this.property.mappingValue(t));
    }

    @Override
    public Node addChildNode(Node parent, T t) {
        R val = this.property.mappingValue(t);
        Supplier<Node> childSupplier = this.next() == null ? this::createNewNode : () -> this.next.createNewNode();
        Number dictKey = this.property.mappingDictKey(val);
        this.property.dict().putDict(dictKey, val);
        return parent.addChild(dictKey, childSupplier);
    }

    @Override
    public Node addChildNode(Node parent, Object val1, Supplier<Node> childNodeSupplier) {
        Object val = val1;
        Number dictKey = this.property.mappingDictKey(val);
        this.property.dict().putDict(dictKey, val);
        return parent.addChild(dictKey, childNodeSupplier);
    }

    @Override
    public void removeChildNode(Node parent, T t) {
        R val = this.property.mappingValue(t);
        if (Objects.isNull(val) || !this.property.dict().containsDictValue(val)) {
            return;
        }
        parent.removeChild(this.property.getDictKey(val));
    }

    @Override
    public Node findChildNode(Node parent, T t) {
        R val = this.property.mappingValue(t);
        if (Objects.isNull(val) || !this.property.dict().containsDictValue(val)) {
            return null;
        }
        return parent.getChild(this.property.getDictKey(val));
    }

    @Override
    public Map<Number, Node> searchAndAgg(Node cur, Criterion criterion, Aggregation aggregation) {
        if (Objects.isNull(criterion) && Objects.isNull((Object)aggregation)) {
            return cur.childMap();
        }
        if (Objects.isNull((Object)aggregation)) {
            return this.search(cur, criterion);
        }
        Map<Number, Node> childMap = this.search(cur, criterion);
        if (childMap.isEmpty()) {
            return childMap;
        }
        switch (this.property.nodeType()) {
            case TREE_MAP: {
                TreeMap<Number, Node> treeMapResult = new TreeMap<Number, Node>();
                switch (aggregation) {
                    case MIN: {
                        Map.Entry minEntry = ((TreeMap)childMap).firstEntry();
                        treeMapResult.put((Number)minEntry.getKey(), (Node)minEntry.getValue());
                        return treeMapResult;
                    }
                    case MAX: {
                        Map.Entry maxEntry = ((TreeMap)childMap).lastEntry();
                        treeMapResult.put((Number)maxEntry.getKey(), (Node)maxEntry.getValue());
                        return treeMapResult;
                    }
                }
                return childMap;
            }
        }
        HashMap<Number, Node> hashMapResult = new HashMap<Number, Node>();
        switch (aggregation) {
            case MIN: {
                Number minDictKey = Long.MAX_VALUE;
                for (Number dictKey : childMap.keySet()) {
                    if (dictKey.longValue() >= minDictKey) continue;
                    minDictKey = dictKey;
                }
                hashMapResult.put(minDictKey, childMap.get(minDictKey));
                return hashMapResult;
            }
            case MAX: {
                Number maxDictKey = Long.MIN_VALUE;
                for (Number dictKey : childMap.keySet()) {
                    if (dictKey.longValue() <= maxDictKey) continue;
                    maxDictKey = dictKey;
                }
                hashMapResult.put(maxDictKey, childMap.get(maxDictKey));
                return hashMapResult;
            }
        }
        return childMap;
    }

    @Override
    public Map<Number, Node> search(Node cur, Criterion criterion) {
        if (Objects.isNull(criterion)) {
            return cur.childMap();
        }
        switch (criterion.getCondition()) {
            case EQUAL: {
                return cur.eq(this.property.getDictKey(criterion.getValue()));
            }
            case BETWEEN: {
                return cur.between(this.property.getDictKey(criterion.getValue()), this.property.getDictKey(criterion.getSecondValue()));
            }
            case GTE: {
                return cur.between(this.property.getDictKey(criterion.getValue()), null);
            }
            case LTE: {
                return cur.between(null, this.property.getDictKey(criterion.getValue()));
            }
            case IN: {
                List inValues = (List)criterion.getValue();
                if (Objects.isNull(inValues) || inValues.isEmpty()) {
                    return cur.childMap();
                }
                return cur.in(inValues.stream().map(this.property::getDictKey).collect(Collectors.toSet()));
            }
            case NOT_IN: {
                List notInValues = (List)criterion.getValue();
                if (Objects.isNull(notInValues) || notInValues.isEmpty()) {
                    return cur.childMap();
                }
                return cur.notIn(notInValues.stream().map(this.property::getDictKey).collect(Collectors.toSet()));
            }
        }
        return cur.childMap();
    }

    @Override
    public boolean contains(Node cur, Criterion criterion) {
        if (Objects.isNull(criterion)) {
            return true;
        }
        switch (criterion.getCondition()) {
            case EQUAL: {
                return cur.containsEq(this.property.getDictKey(criterion.getValue()));
            }
            case BETWEEN: {
                return cur.containsBetween(this.property.getDictKey(criterion.getValue()), this.property.getDictKey(criterion.getSecondValue()));
            }
            case GTE: {
                return cur.containsBetween(this.property.getDictKey(criterion.getValue()), null);
            }
            case LTE: {
                return cur.containsBetween(null, this.property.getDictKey(criterion.getValue()));
            }
            case IN: {
                List inValues = (List)criterion.getValue();
                if (Objects.isNull(inValues) || inValues.isEmpty()) {
                    return cur.getSize() > 0;
                }
                return cur.containsIn(inValues.stream().map(this.property::getDictKey).collect(Collectors.toSet()));
            }
            case NOT_IN: {
                List notInValues = (List)criterion.getValue();
                if (Objects.isNull(notInValues) || notInValues.isEmpty()) {
                    return cur.getSize() > 0;
                }
                return cur.containsNotIn(notInValues.stream().map(this.property::getDictKey).collect(Collectors.toSet()));
            }
        }
        return true;
    }

    @Override
    public void slice(Node cur, Criterion criterion) {
        if (Objects.isNull(criterion)) {
            return;
        }
        cur.setChild(this.search(cur, criterion));
    }

    @Override
    public void remove(Node cur, Criterion criterion) {
        if (Objects.isNull(criterion)) {
            return;
        }
        for (Number k : this.search(cur, criterion).keySet()) {
            cur.childMap().remove(k);
        }
    }

    public NodeManager<T, R> getPrev() {
        return this.prev;
    }

    public NodeManager<T, R> getNext() {
        return this.next;
    }

    public Property<T, R> getProperty() {
        return this.property;
    }

    public void setProperty(Property<T, R> property) {
        this.property = property;
    }

    public void setPrev(NodeManager<T, R> prev) {
        this.prev = prev;
    }

    public void setNext(NodeManager<T, R> next) {
        this.next = next;
    }
}

