/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.node.Node;

public class HashMapNode
implements Node {
    private HashMap<Number, Node> child;

    public HashMapNode() {
        this.child = new HashMap();
    }

    public HashMapNode(Map<Number, Node> child) {
        this.child = new HashMap<Number, Node>(child);
    }

    public HashMapNode(Stream<Number> keys) {
        this.child = new HashMap();
        keys.forEach(key -> this.child.put((Number)key, EmptyNodeHolder.EMPTY_NODE));
    }

    @Override
    public int getSize() {
        return this.child.size();
    }

    @Override
    public Node addChild(Number key, Node childNode) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public Node addChild(Number key, Supplier<Node> childSupplier) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        Node childNode = childSupplier.get();
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public void setChild(Map<Number, Node> childMap) {
        this.child = new HashMap<Number, Node>(childMap);
    }

    @Override
    public Set<Number> keys() {
        return this.child.keySet();
    }

    @Override
    public Map<Number, Node> childMap() {
        return this.child;
    }

    @Override
    public Node getChild(Number key) {
        return this.child.get(key);
    }

    @Override
    public void removeChild(Number key) {
        this.child.remove(key);
    }

    @Override
    public Map<Number, Node> eq(Number key) {
        HashMap result = Maps.newHashMap();
        if (Objects.isNull(key)) {
            return result;
        }
        Node childNode = this.child.get(key);
        if (Objects.nonNull(childNode)) {
            result.put(key, childNode);
        }
        return result;
    }

    @Override
    public Map<Number, Node> between(Number left, Number right) {
        HashMap result = Maps.newHashMap();
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return Maps.newHashMap(this.child);
        }
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.longValue() > right.longValue()) {
                return result;
            }
            this.child.forEach((k, v) -> {
                if (k.longValue() >= left.longValue() && k.longValue() <= right.longValue()) {
                    result.put(k, v);
                }
            });
        } else if (Objects.nonNull(left)) {
            this.child.forEach((k, v) -> {
                if (k.longValue() >= left.longValue()) {
                    result.put(k, v);
                }
            });
        } else {
            this.child.forEach((k, v) -> {
                if (k.longValue() <= right.longValue()) {
                    result.put(k, v);
                }
            });
        }
        return result;
    }

    @Override
    public Map<Number, Node> in(Set<Number> keys) {
        HashMap result = Maps.newHashMap();
        keys.forEach(k -> {
            Node v = this.child.get(k);
            if (Objects.nonNull(v)) {
                result.put(k, v);
            }
        });
        return result;
    }

    @Override
    public Map<Number, Node> notIn(Set<Number> keys) {
        HashMap result = Maps.newHashMap();
        this.child.forEach((k, v) -> {
            if (!keys.contains(k)) {
                result.put(k, v);
            }
        });
        return result;
    }

    @Override
    public boolean containsEq(Number key) {
        return this.child.containsKey(key);
    }

    @Override
    public boolean containsBetween(Number left, Number right) {
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return true;
        }
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.longValue() > right.longValue()) {
                return false;
            }
            return this.child.keySet().stream().anyMatch(k -> k.longValue() >= left.longValue() && k.longValue() <= right.longValue());
        }
        if (Objects.nonNull(left)) {
            return this.child.keySet().stream().anyMatch(k -> k.longValue() >= left.longValue());
        }
        return this.child.keySet().stream().anyMatch(k -> k.longValue() <= right.longValue());
    }

    @Override
    public boolean containsIn(Set<Number> keys) {
        return keys.stream().anyMatch(this.child::containsKey);
    }

    @Override
    public boolean containsNotIn(Set<Number> keys) {
        for (Number number : this.child.keySet()) {
            if (keys.contains(number)) continue;
            return true;
        }
        return false;
    }

    public HashMap<Number, Node> getChild() {
        return this.child;
    }

    public static class EmptyNodeHolder {
        public static final HashMapNode EMPTY_NODE = new HashMapNode();
    }
}

