/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.node.Node;

public class TreeMapNode
implements Node {
    private TreeMap<Number, Node> child;

    public TreeMapNode() {
        this.child = new TreeMap();
    }

    public TreeMapNode(Map<Number, Node> child) {
        this.child = new TreeMap<Number, Node>(child);
    }

    public TreeMapNode(Stream<Number> keys) {
        this.child = new TreeMap();
        keys.forEach(key -> this.child.put((Number)key, EmptyNodeHolder.EMPTY_NODE));
    }

    @Override
    public int getSize() {
        return this.child.size();
    }

    @Override
    public Node addChild(Number key, Node childNode) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public Node addChild(Number key, Supplier<Node> childSupplier) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        Node childNode = childSupplier.get();
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public Set<Number> keys() {
        return this.child.keySet();
    }

    @Override
    public Map<Number, Node> childMap() {
        return this.child;
    }

    @Override
    public Node getChild(Number key) {
        return this.child.get(key);
    }

    @Override
    public void setChild(Map<Number, Node> childMap) {
        this.child = new TreeMap<Number, Node>(childMap);
    }

    @Override
    public void removeChild(Number key) {
        this.child.remove(key);
    }

    @Override
    public Map<Number, Node> eq(Number key) {
        TreeMap<Number, Node> result = new TreeMap<Number, Node>();
        if (Objects.isNull(key)) {
            return result;
        }
        Node childNode = this.child.get(key);
        if (Objects.nonNull(childNode)) {
            result.put(key, childNode);
        }
        return result;
    }

    @Override
    public Map<Number, Node> between(Number left, Number right) {
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return new TreeMap<Number, Node>((SortedMap<Number, Node>)this.child);
        }
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.longValue() > right.longValue()) {
                return new TreeMap<Number, Node>();
            }
            return new TreeMap<Number, Node>((SortedMap<Number, Node>)this.child.subMap(left, true, right, true));
        }
        if (Objects.nonNull(left)) {
            return new TreeMap<Number, Node>((SortedMap<Number, Node>)this.child.tailMap(left, true));
        }
        return new TreeMap<Number, Node>((SortedMap<Number, Node>)this.child.headMap(right, true));
    }

    @Override
    public Map<Number, Node> in(Set<Number> keys) {
        TreeMap<Number, Node> result = new TreeMap<Number, Node>();
        keys.forEach(k -> {
            Node v = this.child.get(k);
            if (Objects.nonNull(v)) {
                result.put((Number)k, v);
            }
        });
        return result;
    }

    @Override
    public Map<Number, Node> notIn(Set<Number> keys) {
        TreeMap<Number, Node> result = new TreeMap<Number, Node>();
        this.child.forEach((k, v) -> {
            if (!keys.contains(k)) {
                result.put((Number)k, (Node)v);
            }
        });
        return result;
    }

    @Override
    public boolean containsEq(Number key) {
        return this.child.containsKey(key);
    }

    @Override
    public boolean containsBetween(Number left, Number right) {
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return true;
        }
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.longValue() > right.longValue()) {
                return false;
            }
            return !this.child.subMap(left, true, right, true).isEmpty();
        }
        if (Objects.nonNull(left)) {
            return !this.child.tailMap(left, true).isEmpty();
        }
        return !this.child.headMap(right, true).isEmpty();
    }

    @Override
    public boolean containsIn(Set<Number> keys) {
        if (keys == null || keys.isEmpty()) {
            return !this.child.isEmpty();
        }
        return keys.stream().anyMatch(this.child::containsKey);
    }

    @Override
    public boolean containsNotIn(Set<Number> keys) {
        if (keys == null || keys.isEmpty()) {
            return !this.child.isEmpty();
        }
        for (Number number : this.child.keySet()) {
            if (keys.contains(number)) continue;
            return true;
        }
        return false;
    }

    public TreeMap<Number, Node> getChild() {
        return this.child;
    }

    public static class EmptyNodeHolder {
        public static final TreeMapNode EMPTY_NODE = new TreeMapNode();
    }
}

