/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import top.chitucao.summerframework.trie.configuration.property.Property;

public class Configuration {
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private int level = 0;
    private Property lastProperty;
    private boolean useFastErase = false;
    private boolean leafNodeAsDataNode;

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Property getLastProperty() {
        return this.lastProperty;
    }

    public void addProperty(Property property) {
        property.setLevel(this.level++);
        this.lastProperty = property;
        this.properties.put(property.name(), property);
    }

    public void sortProperties(Comparator<String> comparator) {
        ArrayList<Map.Entry<String, Property>> entryList = new ArrayList<Map.Entry<String, Property>>(this.properties.entrySet());
        entryList.sort((o1, o2) -> comparator.compare((String)o1.getKey(), (String)o2.getKey()));
        this.properties.clear();
        this.level = 0;
        for (Map.Entry entry : entryList) {
            ((Property)entry.getValue()).setLevel(this.level++);
            this.properties.put((String)entry.getKey(), (Property)entry.getValue());
        }
    }

    public boolean isUseFastErase() {
        return this.useFastErase;
    }

    public void setUseFastErase(boolean useFastErase) {
        this.useFastErase = useFastErase;
    }

    public boolean isLeafNodeAsDataNode() {
        return this.leafNodeAsDataNode;
    }

    public void setLeafNodeAsDataNode(boolean leafNodeAsDataNode) {
        this.leafNodeAsDataNode = leafNodeAsDataNode;
    }
}

