/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.configuration.property;

import java.util.function.Function;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.dict.Dict;
import top.chitucao.summerframework.trie.dict.HashMapDict;
import top.chitucao.summerframework.trie.node.NodeType;

public abstract class AbstractProperty<T, R>
implements Property<T, R> {
    protected final String name;
    protected int level;
    protected final NodeType nodeType;
    protected final Dict<R> dict;
    private Function<T, R> propertyMapper;

    public AbstractProperty(String name) {
        this.name = name;
        this.nodeType = NodeType.HASH_MAP;
        this.dict = new HashMapDict();
    }

    public AbstractProperty(String name, NodeType nodeType) {
        this.name = name;
        this.nodeType = nodeType;
        this.dict = new HashMapDict();
    }

    public AbstractProperty(String name, Dict<R> dict) {
        this.name = name;
        this.nodeType = NodeType.HASH_MAP;
        this.dict = dict;
    }

    public AbstractProperty(String name, NodeType nodeType, Dict<R> dict) {
        this.name = name;
        this.nodeType = nodeType;
        this.dict = dict;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public NodeType nodeType() {
        return this.nodeType;
    }

    @Override
    public R mappingValue(T t) {
        return this.propertyMapper.apply(t);
    }

    @Override
    public Dict<R> dict() {
        return this.dict;
    }

    public void setPropertyMapper(Function<T, R> propertyMapper) {
        this.propertyMapper = propertyMapper;
    }
}

