/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.node.Node;

public class HashMapNode
implements Node {
    private HashMap<Number, Node> child;

    public HashMapNode() {
        this.child = new HashMap();
    }

    public HashMapNode(Map<Number, Node> child) {
        this.child = new HashMap<Number, Node>(child);
    }

    public HashMapNode(Stream<Number> keys) {
        this.child = new HashMap();
        keys.forEach(key -> this.child.put((Number)key, EmptyNodeHolder.EMPTY_NODE));
    }

    @Override
    public int getSize() {
        return this.child.size();
    }

    @Override
    public Node addChild(Number key, Node childNode) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public Node addChild(Number key, Supplier<Node> childSupplier) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        Node childNode = childSupplier.get();
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public void setChild(Map<Number, Node> childMap) {
        this.child = new HashMap<Number, Node>(childMap);
    }

    @Override
    public Set<Number> keys() {
        return this.child.keySet();
    }

    @Override
    public Map<Number, Node> childMap() {
        return this.child;
    }

    @Override
    public Node getChild(Number key) {
        return this.child.get(key);
    }

    @Override
    public void removeChild(Number key) {
        this.child.remove(key);
    }

    public static class EmptyNodeHolder {
        public static final HashMapNode EMPTY_NODE = new HashMapNode();
    }
}

