/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.node.Node;

public class TreeMapNode
implements Node {
    private TreeMap<Number, Node> child;

    public TreeMapNode() {
        this.child = new TreeMap();
    }

    public TreeMapNode(Map<Number, Node> child) {
        this.child = new TreeMap<Number, Node>(child);
    }

    public TreeMapNode(Stream<Number> keys) {
        this.child = new TreeMap();
        keys.forEach(key -> this.child.put((Number)key, EmptyNodeHolder.EMPTY_NODE));
    }

    @Override
    public int getSize() {
        return this.child.size();
    }

    @Override
    public Node addChild(Number key, Node childNode) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public Node addChild(Number key, Supplier<Node> childSupplier) {
        Node exChildNode = this.child.get(key);
        if (Objects.nonNull(exChildNode)) {
            return exChildNode;
        }
        Node childNode = childSupplier.get();
        this.child.put(key, childNode);
        return childNode;
    }

    @Override
    public Set<Number> keys() {
        return this.child.keySet();
    }

    @Override
    public Map<Number, Node> childMap() {
        return this.child;
    }

    @Override
    public Node getChild(Number key) {
        return this.child.get(key);
    }

    @Override
    public void setChild(Map<Number, Node> childMap) {
        this.child = new TreeMap<Number, Node>(childMap);
    }

    @Override
    public void removeChild(Number key) {
        this.child.remove(key);
    }

    public static class EmptyNodeHolder {
        public static final TreeMapNode EMPTY_NODE = new TreeMapNode();
    }
}

