/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.operation.Operate;

public class BasicOperates {
    public static final Operate HASH_MAP_EQ_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashMap<Number, Node> result = new HashMap<Number, Node>();
        Node childNode = (Node)childMap.get(key);
        if (Objects.nonNull(childNode)) {
            result.put((Number)key, childNode);
        }
        return result;
    };
    public static final Operate HASH_MAP_NE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (Objects.equals(entry.getKey(), key)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_GT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Number)entry.getKey()).longValue() <= ((Number)key).longValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_GTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Number)entry.getKey()).longValue() < ((Number)key).longValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_LT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Number)entry.getKey()).longValue() >= ((Number)key).longValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_LTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Number)entry.getKey()).longValue() > ((Number)key).longValue()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_BETWEEN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        List range = (List)key;
        Number left = (Number)range.get(0);
        Number right = (Number)range.get(1);
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return childMap;
        }
        HashMap result = new HashMap();
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.longValue() > right.longValue()) {
                return childMap;
            }
            for (Map.Entry entry : childMap.entrySet()) {
                if (((Number)entry.getKey()).longValue() < left.longValue() || ((Number)entry.getKey()).longValue() > right.longValue()) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        } else if (Objects.nonNull(left)) {
            for (Map.Entry entry : childMap.entrySet()) {
                if (((Number)entry.getKey()).longValue() < left.longValue()) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry entry : childMap.entrySet()) {
                if (((Number)entry.getKey()).longValue() > right.longValue()) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    };
    public static final Operate HASH_MAP_IN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (!keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_NIN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate TREE_MAP_EQ_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        TreeMap<Number, Node> result = new TreeMap<Number, Node>();
        Node childNode = (Node)childMap.get(key);
        if (Objects.nonNull(childNode)) {
            result.put((Number)key, childNode);
        }
        return result;
    };
    public static final Operate TREE_MAP_NE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        TreeMap result = new TreeMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (Objects.equals(entry.getKey(), key)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate TREE_MAP_GT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        return new TreeMap(((TreeMap)childMap).tailMap((Number)key, false));
    };
    public static final Operate TREE_MAP_GTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        return new TreeMap(((TreeMap)childMap).tailMap((Number)key, true));
    };
    public static final Operate TREE_MAP_LT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        return new TreeMap(((TreeMap)childMap).headMap((Number)key, false));
    };
    public static final Operate TREE_MAP_LTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        return new TreeMap(((TreeMap)childMap).headMap((Number)key, true));
    };
    public static final Operate TREE_MAP_BETWEEN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        List range = (List)key;
        Number left = (Number)range.get(0);
        Number right = (Number)range.get(1);
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return new TreeMap(childMap);
        }
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.longValue() > right.longValue()) {
                return new TreeMap();
            }
            return new TreeMap(((TreeMap)childMap).subMap(left, true, right, true));
        }
        if (Objects.nonNull(left)) {
            return new TreeMap(((TreeMap)childMap).tailMap(left, true));
        }
        return new TreeMap(((TreeMap)childMap).headMap(right, true));
    };
    public static final Operate TREE_MAP_IN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        TreeMap result = new TreeMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (!keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate TREE_MAP_NIN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        TreeMap result = new TreeMap();
        for (Map.Entry entry : childMap.entrySet()) {
            if (keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };

    public static <T, R> Object mapperDictKey(Property<T, R> property, Object value) {
        if (Objects.isNull(value)) {
            return value;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.isEmpty()) {
                return Collections.emptyList();
            }
            return values.stream().map(property::getDictKey).collect(Collectors.toList());
        }
        return property.getDictKey(value);
    }

    public static <T, R> Object mapperDictValue(Property<T, R> property, Number key) {
        return property.dict().getDictValue(key);
    }
}

