/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.Trie;
import top.chitucao.summerframework.trie.configuration.Configuration;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.nodemanager.DefaultNodeManagerFactory;
import top.chitucao.summerframework.trie.nodemanager.NodeManager;
import top.chitucao.summerframework.trie.query.Aggregation;
import top.chitucao.summerframework.trie.query.Aggregations;
import top.chitucao.summerframework.trie.query.Criteria;
import top.chitucao.summerframework.trie.query.Criterion;
import top.chitucao.summerframework.trie.query.ResultBuilder;
import top.chitucao.summerframework.trie.utils.Pair;

public class MapTrie<T>
implements Trie<T> {
    private final Node<?> root;
    private final Configuration configuration;
    private final LinkedList<NodeManager> nodeManagers;
    private final Map<String, NodeManager> nodeManagerNameMap;

    public MapTrie(Configuration configuration) {
        this.checkAndResolveConfiguration(configuration);
        this.configuration = configuration;
        DefaultNodeManagerFactory nodeManagerFactory = new DefaultNodeManagerFactory(configuration);
        this.nodeManagers = nodeManagerFactory.createNodeManagers();
        this.nodeManagerNameMap = this.nodeManagers.stream().collect(Collectors.toMap(m -> m.property().name(), Function.identity()));
        this.root = this.headNodeManager().createNewNode();
    }

    @Override
    public int getDepth() {
        return this.tailNodeManager().property().level();
    }

    @Override
    public int getSize() {
        return this.doGetSize(this.root, 0, this.getDepth());
    }

    @Override
    public void insert(T t) {
        Node<?> cur = this.root;
        for (NodeManager nodeManager : this.nodeManagers) {
            cur = nodeManager.addChildNode(cur, t);
        }
    }

    @Override
    public int erase(Criteria criteria) {
        this.criteriaNotNullCheck(criteria);
        if (this.configuration.isUseFastErase()) {
            this.fastErase(criteria);
            return -1;
        }
        return this.normErase(criteria);
    }

    private int normErase(Criteria criteria) {
        return Math.abs(this.doNormErase(this.root, this.headNodeManager(), criteria.getAllCriterion()));
    }

    private int doNormErase(Node<?> cur, NodeManager nodeManager, Map<String, Criterion> criterionMap) {
        String propertyName = nodeManager.property().name();
        Criterion criterion = criterionMap.get(propertyName);
        if (Objects.isNull(nodeManager.next())) {
            if (Objects.isNull(criterion)) {
                Set<?> dictKeySet = cur.childKeySet();
                for (Object dictKey : dictKeySet) {
                    Property property = nodeManager.property();
                    if (!property.isDictProperty()) continue;
                    property.getDict().removeNodeKey(dictKey);
                }
                return -dictKeySet.size();
            }
            Set<?> dictKeySet = nodeManager.search(cur, criterion).keySet();
            for (Object dictKey : dictKeySet) {
                nodeManager.removeChild(cur, dictKey);
            }
            return cur.childSize() == 0 ? -dictKeySet.size() : dictKeySet.size();
        }
        Map<?, Node<?>> childMap = Objects.isNull(criterion) ? cur.children() : nodeManager.search(cur, criterion);
        int sum = 0;
        Iterator<Map.Entry<?, Node<?>>> iterator = childMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, Node<?>> entry = iterator.next();
            int removeCount = this.doNormErase(entry.getValue(), nodeManager.next(), criterionMap);
            if (removeCount < 0) {
                iterator.remove();
            }
            int removeCountAbs = Math.abs(removeCount);
            Property property = nodeManager.property();
            if (property.isDictProperty()) {
                property.getDict().decrNodeKeyCount(entry.getKey(), removeCountAbs);
            }
            sum += removeCountAbs;
        }
        return cur.children().isEmpty() ? -sum : sum;
    }

    private void fastErase(Criteria criteria) {
        Map<String, Criterion> criterionMap = criteria.getAllCriterion();
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criterionMap);
        Iterator iterator = this.nodeManagers.iterator();
        Stream<Node<Object>> cur = Stream.of(this.root);
        for (int i = 0; i < maxCriteriaLevel; ++i) {
            NodeManager nodeManager = (NodeManager)iterator.next();
            cur = cur.flatMap(e -> nodeManager.search(e, (Criterion)criterionMap.get(nodeManager.property().name())).values().stream());
        }
        NodeManager lastNodemanager = (NodeManager)iterator.next();
        cur.forEach(e -> lastNodemanager.remove(e, (Criterion)criterionMap.get(lastNodemanager.property().name())));
    }

    @Override
    public void erase(T t) {
        Property property;
        Node<?> cur = this.root;
        NodeManager nodeManager = this.headNodeManager();
        Stack parentNodeStack = new Stack();
        while (Objects.nonNull(nodeManager)) {
            Node<?> childNode = nodeManager.findChildNode(cur, t);
            if (Objects.isNull(childNode)) {
                return;
            }
            nodeManager = nodeManager.next();
            parentNodeStack.push(cur);
            cur = childNode;
        }
        if (Objects.isNull(cur)) {
            return;
        }
        nodeManager = this.tailNodeManager();
        while (Objects.nonNull(nodeManager)) {
            Node parent = (Node)parentNodeStack.pop();
            nodeManager.removeChildNode(parent, t);
            if (parent.childSize() != 0) break;
            nodeManager = nodeManager.prev();
        }
        nodeManager = this.headNodeManager();
        while (Objects.nonNull(nodeManager.next())) {
            property = nodeManager.property();
            if (property.isDictProperty()) {
                property.getDict().decrNodeKeyCount(nodeManager.mappingDictKey(t), 1);
            }
            nodeManager = nodeManager.next();
        }
        property = nodeManager.property();
        if (property.isDictProperty()) {
            property.getDict().removeNodeKey(nodeManager.mappingDictKey(t));
        }
    }

    @Override
    public boolean contains(Criteria criteria) {
        this.criteriaNotNullCheck(criteria);
        Map<String, Criterion> criterion = criteria.getAllCriterion();
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criteria.getAllCriterion());
        return !this.levelSearch(criterion, new Aggregations(), maxCriteriaLevel).isEmpty();
    }

    @Override
    public boolean contains(T t) {
        Node<?> cur = this.root;
        for (NodeManager nodeManager : this.nodeManagers) {
            Node<?> childNode = nodeManager.findChildNode(cur, t);
            if (Objects.isNull(childNode)) {
                return false;
            }
            cur = childNode;
        }
        return true;
    }

    @Override
    public List<T> dataSearch(Criteria criteria) {
        if (!this.configuration.isLeafNodeAsDataNode()) {
            throw new IllegalStateException("Leaf node is not a data node, Data search is not supported");
        }
        Map<String, Criterion> criterionMap = MapTrie.getCriterionMap(criteria);
        return this.tailNodeManager().mappingDictValues(this.levelSearch(criterionMap, new Aggregations(), this.tailNodeManager().property().level())).collect(Collectors.toList());
    }

    @Override
    public <R> List<R> propertySearch(Criteria criteria, String property) {
        this.propertyCheck(property);
        Map<String, Criterion> criterionMap = MapTrie.getCriterionMap(criteria);
        return this.nodeManagerNameMap.get(property).mappingDictValues(this.levelSearch(criterionMap, new Aggregations(), this.nodeManagerNameMap.get(property).property().level())).collect(Collectors.toList());
    }

    private Set<?> levelSearch(Map<String, Criterion> criterionMap, Aggregations aggregations, int level) {
        Iterator iterator = this.nodeManagers.iterator();
        Map<String, Aggregation> aggregationMap = aggregations.getAggregationMap();
        Stream<Node<Object>> cur = Stream.of(this.root);
        for (int i = 0; i < level; ++i) {
            NodeManager nodeManager = (NodeManager)iterator.next();
            String propertyName = nodeManager.property().name();
            cur = cur.flatMap(e -> nodeManager.searchAndAgg(e, (Criterion)criterionMap.get(propertyName), (Aggregation)((Object)((Object)aggregationMap.get(propertyName)))).values().stream());
        }
        NodeManager levelManager = (NodeManager)iterator.next();
        String levelPropertyName = levelManager.property().name();
        Stream<Map> curChildMap = cur.map(node -> levelManager.searchAndAgg(node, (Criterion)criterionMap.get(levelPropertyName), (Aggregation)((Object)((Object)aggregationMap.get(levelPropertyName))))).filter(e -> !e.isEmpty());
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criterionMap);
        if (levelManager.property().level() >= maxCriteriaLevel) {
            return curChildMap.flatMap(childMap -> childMap.keySet().stream()).collect(Collectors.toSet());
        }
        HashSet keys = new HashSet();
        NodeManager next = (NodeManager)iterator.next();
        curChildMap.forEach(map -> map.forEach((k, v) -> {
            if (!keys.contains(k) && this.childrenAnyMatch((Node<?>)v, next, criterionMap, aggregationMap, maxCriteriaLevel)) {
                keys.add(k);
            }
        }));
        return keys;
    }

    private boolean childrenAnyMatch(Node<?> node, NodeManager nodeManager, Map<String, Criterion> criteriaMap, Map<String, Aggregation> aggregationMap, int maxCriteriaLevel) {
        String propertyName = nodeManager.property().name();
        Criterion criterion = criteriaMap.get(propertyName);
        if (nodeManager.property().level() == maxCriteriaLevel) {
            return nodeManager.contains(node, criterion);
        }
        Stream<Node<Object>> cur = Stream.of(node);
        cur = cur.flatMap(e -> nodeManager.searchAndAgg(e, criterion, (Aggregation)((Object)((Object)aggregationMap.get(propertyName)))).values().stream());
        return cur.anyMatch(childNode -> this.childrenAnyMatch((Node<?>)childNode, nodeManager.next(), criteriaMap, aggregationMap, maxCriteriaLevel));
    }

    @Override
    public <E> List<E> listSearch(Criteria criteria, Aggregations aggregations, ResultBuilder<E> resultBuilder) {
        this.resultBuilderCheck(resultBuilder);
        Map<String, Criterion> criterionMap = MapTrie.getCriterionMap(criteria);
        List<List<?>> dataList = this.multiLevelSearch(criterionMap, aggregations, resultBuilder.getSetterMap().keySet().toArray(new String[0]));
        if (dataList.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<E> result = new ArrayList<E>();
        List<Pair<NodeManager, BiConsumer>> propertySetterList = this.getPropertySetterList(resultBuilder);
        for (List<?> fields : dataList) {
            E data = resultBuilder.getSupplier().get();
            for (int i = 0; i < fields.size(); ++i) {
                Pair<NodeManager, BiConsumer> pair = propertySetterList.get(i);
                try {
                    pair.getValue().accept(data, pair.getKey().property().nodeKey2FieldValue(fields.get(i)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Property value set failed. Property name is " + pair.getKey().property().name() + ". Error msg: " + e.getMessage(), e.getCause());
                }
            }
            result.add(data);
        }
        return result;
    }

    @Override
    public Object treeSearch(Criteria criteria, Aggregations aggregations, String ... properties) {
        if (properties == null || properties.length == 0) {
            return new ArrayList();
        }
        if (properties.length == 1) {
            return this.propertySearch(criteria, properties[0]);
        }
        Map<String, Criterion> criterionMap = MapTrie.getCriterionMap(criteria);
        List<List<?>> dataList = this.multiLevelSearch(criterionMap, aggregations, properties);
        if (dataList.isEmpty()) {
            return new HashMap();
        }
        List<NodeManager> propertyNodeManagerList = this.getPropertyNodeManagerList(properties);
        HashMap result = new HashMap();
        for (List<?> fields : dataList) {
            HashMap cur = result;
            for (int i = 0; i < properties.length; ++i) {
                Object dictValue = propertyNodeManagerList.get(i).property().nodeKey2FieldValue(fields.get(i));
                if (i < properties.length - 1) {
                    Map map = cur;
                    if (!map.containsKey(dictValue)) {
                        if (i == properties.length - 2) {
                            map.put(dictValue, new ArrayList());
                        } else {
                            map.put(dictValue, new HashMap());
                        }
                    }
                    cur = map.get(dictValue);
                    continue;
                }
                List list = (List)((Object)cur);
                list.add(dictValue);
            }
        }
        return result;
    }

    private List<List<?>> multiLevelSearch(Map<String, Criterion> criterionMap, Aggregations aggregations, String ... properties) {
        if (properties == null || properties.length == 0) {
            return new ArrayList();
        }
        this.propertiesCheck(properties);
        this.sortProperties(properties);
        if (Objects.isNull(aggregations)) {
            aggregations = new Aggregations();
        }
        this.aggregationCheck(aggregations);
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criterionMap);
        int maxPropertyLevel = this.getMaxPropertyLevel(properties);
        ArrayList result = new ArrayList();
        this.dfsSearch(this.root, this.headNodeManager(), criterionMap, maxCriteriaLevel, new HashSet<String>(Arrays.asList(properties)), maxPropertyLevel, aggregations.getAggregationMap(), result, new ArrayList());
        return result;
    }

    private void dfsSearch(Node<?> cur, NodeManager nodeManager, Map<String, Criterion> criteriaMap, int maxCriteriaLevel, Set<String> propertySet, int maxPropertyLevel, Map<String, Aggregation> aggregationMap, List<List<?>> result, List<?> path) {
        int level = nodeManager.property().level();
        String propertyName = nodeManager.property().name();
        if (level > maxCriteriaLevel && level > maxPropertyLevel) {
            result.add(path);
            return;
        }
        Criterion criterion = criteriaMap.get(propertyName);
        Aggregation aggregation = aggregationMap.get(propertyName);
        Map<?, Node<?>> map = nodeManager.searchAndAgg(cur, criterion, aggregation);
        boolean isResultProperty = propertySet.contains(propertyName);
        for (Map.Entry<?, Node<?>> entry : map.entrySet()) {
            ArrayList newPath = new ArrayList(path);
            if (isResultProperty) {
                newPath.add(entry.getKey());
            }
            if (Objects.isNull(nodeManager.next())) {
                result.add(newPath);
                return;
            }
            this.dfsSearch(entry.getValue(), nodeManager.next(), criteriaMap, maxCriteriaLevel, propertySet, maxPropertyLevel, aggregationMap, result, newPath);
        }
    }

    @Override
    public <R> Set<R> dictValues(String property, Object ... dictKeys) {
        this.propertyCheck(property);
        Property property1 = this.nodeManagerNameMap.get(property).property();
        if (dictKeys == null || dictKeys.length == 0) {
            return property1.getDict().fieldValues();
        }
        Map dictAll = property1.getDict().dict();
        return Arrays.stream(dictKeys).map(dictAll::get).collect(Collectors.toSet());
    }

    private static Map<String, Criterion> getCriterionMap(Criteria criteria) {
        return Objects.isNull(criteria) ? new HashMap() : criteria.getAllCriterion();
    }

    private int getMaxPropertyLevel(String ... properties) {
        return this.nodeManagerNameMap.get(properties[properties.length - 1]).property().level();
    }

    private int getMaxCriteriaLevel(Map<String, Criterion> criterionMap) {
        if (criterionMap.isEmpty()) {
            return -1;
        }
        Set<String> keys = criterionMap.keySet();
        for (NodeManager tNodeManager = this.tailNodeManager(); tNodeManager != null; tNodeManager = tNodeManager.prev()) {
            if (!keys.contains(tNodeManager.property().name())) continue;
            return tNodeManager.property().level();
        }
        return -1;
    }

    private <E> List<Pair<NodeManager, BiConsumer>> getPropertySetterList(ResultBuilder<E> resultBuilder) {
        ArrayList<Pair<NodeManager, BiConsumer>> propertySetterList = new ArrayList<Pair<NodeManager, BiConsumer>>();
        for (NodeManager nodeManager : this.nodeManagers) {
            String propertyName = nodeManager.property().name();
            if (!resultBuilder.getSetterMap().containsKey(propertyName)) continue;
            propertySetterList.add(new Pair<NodeManager, BiConsumer>(nodeManager, resultBuilder.getSetterMap().get(propertyName)));
        }
        return propertySetterList;
    }

    private List<NodeManager> getPropertyNodeManagerList(String ... properties) {
        HashSet<String> propertySet = new HashSet<String>(Arrays.asList(properties));
        ArrayList<NodeManager> propertyNodeManagerList = new ArrayList<NodeManager>();
        for (NodeManager nodeManager : this.nodeManagers) {
            String propertyName = nodeManager.property().name();
            if (!propertySet.contains(propertyName)) continue;
            propertyNodeManagerList.add(nodeManager);
        }
        return propertyNodeManagerList;
    }

    private void sortProperties(String ... properties) {
        Arrays.sort(properties, Comparator.comparing(p -> this.nodeManagerNameMap.get(p).property().level()));
    }

    private NodeManager headNodeManager() {
        return this.nodeManagers.getFirst();
    }

    private NodeManager tailNodeManager() {
        return this.nodeManagers.getLast();
    }

    private int doGetSize(Node<?> cur, int depth, int maxDepth) {
        if (depth == maxDepth || cur.children().isEmpty()) {
            return cur.childSize();
        }
        int sumSize = 0;
        for (Node<?> child : cur.children().values()) {
            sumSize += this.doGetSize(child, depth + 1, maxDepth);
        }
        return sumSize;
    }

    private void checkAndResolveConfiguration(Configuration configuration) {
        if (configuration.getProperties().isEmpty()) {
            throw new IllegalStateException("Properties are empty");
        }
        configuration.setLeafNodeAsDataNode(this.checkNodeAsDataNode(configuration.getLastProperty()));
    }

    private boolean checkNodeAsDataNode(Property property) {
        try {
            Object obj = new Object();
            return obj == property.mappingFieldValue(obj);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void criteriaNotNullCheck(Criteria criteria) {
        if (Objects.isNull(criteria)) {
            throw new IllegalArgumentException("Criteria can not be null");
        }
    }

    private void aggregationCheck(Aggregations aggregations) {
        Map<String, Aggregation> aggregationMap = aggregations.getAggregationMap();
        if (aggregationMap.isEmpty()) {
            return;
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (Map.Entry<String, Aggregation> entry : aggregationMap.entrySet()) {
            if (!this.nodeManagerNameMap.containsKey(entry.getKey())) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(entry.getKey()));
            }
            if (propertySet.add(entry.getKey())) continue;
            throw new IllegalArgumentException("Duplicate property: " + (Object)((Object)entry.getValue()) + " in aggregations");
        }
    }

    private <E> void resultBuilderCheck(ResultBuilder<E> resultBuilder) {
        Map<String, BiConsumer> setterMap = resultBuilder.getSetterMap();
        if (setterMap.isEmpty()) {
            throw new IllegalArgumentException("ResultBuilder setter map is empty");
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (Map.Entry<String, BiConsumer> entry : setterMap.entrySet()) {
            if (!this.nodeManagerNameMap.containsKey(entry.getKey())) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(entry.getKey()));
            }
            if (propertySet.add(entry.getKey())) continue;
            throw new IllegalArgumentException("Duplicate property: " + entry.getValue() + " in resultBuilder");
        }
    }

    private void propertiesCheck(String ... properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (String property : properties) {
            if (!this.nodeManagerNameMap.containsKey(property)) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(property));
            }
            if (propertySet.add(property)) continue;
            throw new IllegalArgumentException("Duplicate property: " + property + "in properties");
        }
    }

    private void propertyCheck(String property) {
        if (!this.nodeManagerNameMap.containsKey(property)) {
            throw new IllegalArgumentException(this.propertyNotDefinedMsg(property));
        }
    }

    private String propertyNotDefinedMsg(String property) {
        return "Property: " + property + " is not defined, Properties: " + this.nodeManagerNameMap.keySet();
    }
}

