/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.dict;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import top.chitucao.summerframework.trie.dict.Dict;

public class HashMapDict<R, K>
implements Dict<R, K> {
    protected Map<K, R> dict;
    protected Map<R, K> indexer;
    protected Map<K, Integer> counter;
    protected boolean removeDictIfNonCount;

    public HashMapDict() {
        this.dict = new ConcurrentHashMap<K, R>();
        this.indexer = new ConcurrentHashMap<R, K>();
        this.counter = new ConcurrentHashMap<K, Integer>();
        this.removeDictIfNonCount = true;
    }

    public HashMapDict(Integer capacity) {
        this.dict = new ConcurrentHashMap<K, R>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.indexer = new ConcurrentHashMap<R, K>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.counter = new ConcurrentHashMap<K, Integer>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.removeDictIfNonCount = true;
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public Map<K, R> dict() {
        return this.dict;
    }

    @Override
    public Set<R> fieldValues() {
        return this.indexer.keySet();
    }

    @Override
    public void put(K nodeKey, R fieldValue) {
        this.indexer.put(fieldValue, nodeKey);
        this.dict.put(nodeKey, fieldValue);
        this.counter.put(nodeKey, this.counter.getOrDefault(nodeKey, 0) + 1);
    }

    @Override
    public K getNodeKey(R fieldValue) {
        return this.indexer.get(fieldValue);
    }

    @Override
    public R getFieldValue(K nodeKey) {
        return this.dict.get(nodeKey);
    }

    @Override
    public boolean containsFieldValue(R fieldValue) {
        return this.indexer.containsKey(fieldValue);
    }

    @Override
    public void decrNodeKeyCount(K nodeKey, int count) {
        if (!this.counter.containsKey(nodeKey)) {
            return;
        }
        this.counter.put(nodeKey, this.counter.get(nodeKey) - count);
        if (this.removeDictIfNonCount && Objects.equals(this.counter.get(nodeKey), 0)) {
            this.removeNodeKey(nodeKey);
        }
    }

    @Override
    public void removeNodeKey(K nodeKey) {
        this.indexer.remove(this.dict.get(nodeKey));
        this.dict.remove(nodeKey);
        this.counter.remove(nodeKey);
    }
}

