/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.operation;

import java.util.HashMap;
import java.util.Map;
import top.chitucao.summerframework.trie.node.NodeType;
import top.chitucao.summerframework.trie.operation.BasicOperates;
import top.chitucao.summerframework.trie.operation.Operate;
import top.chitucao.summerframework.trie.operation.Operation;

public class OperationRegistry {
    public static final OperationRegistry INSTANCE = new OperationRegistry();
    private final Map<String, Map<String, Operate>> nodeOperationRegistry = new HashMap<String, Map<String, Operate>>();

    public OperationRegistry() {
        this.registerBaseOperations();
    }

    public static OperationRegistry getInstance() {
        return INSTANCE;
    }

    public void registerBaseOperations() {
        this.registerOperation(NodeType.HASH_MAP, Operation.EQ.getValue(), BasicOperates.HASH_MAP_EQ_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.NE.getValue(), BasicOperates.HASH_MAP_NE_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.GT.getValue(), BasicOperates.HASH_MAP_GT_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.GTE.getValue(), BasicOperates.HASH_MAP_GTE_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.LT.getValue(), BasicOperates.HASH_MAP_LT_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.LTE.getValue(), BasicOperates.HASH_MAP_LTE_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.BETWEEN.getValue(), BasicOperates.HASH_MAP_BETWEEN_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.IN.getValue(), BasicOperates.HASH_MAP_IN_OP);
        this.registerOperation(NodeType.HASH_MAP, Operation.NIN.getValue(), BasicOperates.HASH_MAP_NIN_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.EQ.getValue(), BasicOperates.TREE_MAP_EQ_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.NE.getValue(), BasicOperates.TREE_MAP_NE_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.GT.getValue(), BasicOperates.TREE_MAP_GT_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.GTE.getValue(), BasicOperates.TREE_MAP_GTE_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.LT.getValue(), BasicOperates.TREE_MAP_LT_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.LTE.getValue(), BasicOperates.TREE_MAP_LTE_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.BETWEEN.getValue(), BasicOperates.TREE_MAP_BETWEEN_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.IN.getValue(), BasicOperates.TREE_MAP_IN_OP);
        this.registerOperation(NodeType.TREE_MAP, Operation.NIN.getValue(), BasicOperates.TREE_MAP_NIN_OP);
    }

    public void registerOperation(NodeType nodeType, String operationName, Operate operation) {
        this.registerOperation(nodeType.name(), operationName, operation);
    }

    public void registerOperation(String nodeType, String operationName, Operate operation) {
        Map nodeTypeOperationMap = this.nodeOperationRegistry.getOrDefault(nodeType, new HashMap());
        if (nodeTypeOperationMap.containsKey(operationName)) {
            throw new IllegalArgumentException("Node type " + nodeType + " already has an operation named " + operationName);
        }
        nodeTypeOperationMap.put(operationName, operation);
        this.nodeOperationRegistry.put(nodeType, nodeTypeOperationMap);
    }

    public Operate getOperate(String nodeType, String operationName) {
        return this.nodeOperationRegistry.get(nodeType).get(operationName);
    }
}

