/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import top.chitucao.summerframework.trie.node.Node;

public abstract class AbstractMapNode<K>
implements Node<K> {
    protected Map<K, Node<K>> children;

    @Override
    public Map<K, Node<K>> children() {
        return this.children;
    }

    @Override
    public int childSize() {
        return this.children.size();
    }

    @Override
    public Set<K> childKeySet() {
        return this.children.keySet();
    }

    @Override
    public Node<K> child(K key) {
        return this.children.get(key);
    }

    @Override
    public Node<K> putChild(K key, Node<K> child) {
        Node<K> existChild = this.children.get(key);
        if (Objects.nonNull(existChild)) {
            return existChild;
        }
        this.children.put(key, child);
        return child;
    }

    @Override
    public Node<K> putChild(K key, Supplier<Node<K>> childSupplier) {
        Node<K> existChild = this.children.get(key);
        if (Objects.nonNull(existChild)) {
            return existChild;
        }
        Node<K> child = childSupplier.get();
        this.children.put(key, child);
        return child;
    }

    @Override
    public void removeChild(K key) {
        this.children.remove(key);
    }
}

