/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import java.util.HashMap;
import java.util.Map;
import top.chitucao.summerframework.trie.node.HashMapNode;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.node.NodeFactory;
import top.chitucao.summerframework.trie.node.NodeType;
import top.chitucao.summerframework.trie.node.TreeMapNode;
import top.chitucao.summerframework.trie.node.extra.NamedHashMapNode;
import top.chitucao.summerframework.trie.node.extra.NamedTreeMapNode;

public class NodeFactoryRegistry {
    public static final NodeFactoryRegistry INSTANCE = new NodeFactoryRegistry();
    private final Map<String, NodeFactory> registry = new HashMap<String, NodeFactory>();

    public NodeFactoryRegistry() {
        this.registerBaseNodeFactories();
    }

    public static NodeFactoryRegistry getInstance() {
        return INSTANCE;
    }

    private void registerBaseNodeFactories() {
        this.registerNodeFactory(NodeType.HASH_MAP, new NodeFactory(){

            @Override
            public boolean isFromTreeMap() {
                return false;
            }

            @Override
            public <K> Node<K> newNode() {
                return new HashMapNode();
            }
        });
        this.registerNodeFactory(NodeType.TREE_MAP, new NodeFactory(){

            @Override
            public boolean isFromTreeMap() {
                return true;
            }

            @Override
            public <K> Node<K> newNode() {
                return new TreeMapNode();
            }
        });
        this.registerNodeFactory(NodeType.NAMED_HASH_MAP, new NodeFactory(){

            @Override
            public boolean isFromTreeMap() {
                return false;
            }

            @Override
            public <K> Node<K> newNode() {
                return new NamedHashMapNode();
            }
        });
        this.registerNodeFactory(NodeType.NAMED_TREE_MAP, new NodeFactory(){

            @Override
            public boolean isFromTreeMap() {
                return true;
            }

            @Override
            public <K> Node<K> newNode() {
                return new NamedTreeMapNode();
            }
        });
    }

    public void registerNodeFactory(NodeType nodeType, NodeFactory nodeFactory) {
        this.registry.put(nodeType.name(), nodeFactory);
    }

    public void registerNodeFactory(String nodeType, NodeFactory nodeFactory) {
        this.registry.put(nodeType, nodeFactory);
    }

    public NodeFactory getNodeFactory(String nodeType) {
        return this.registry.get(nodeType);
    }
}

