/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.nodemanager;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import top.chitucao.summerframework.trie.configuration.Configuration;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.nodemanager.DefaultNodeManager;
import top.chitucao.summerframework.trie.nodemanager.NodeManager;
import top.chitucao.summerframework.trie.nodemanager.NodeManagerFactory;

public class DefaultNodeManagerFactory
implements NodeManagerFactory {
    private final Configuration configuration;

    public DefaultNodeManagerFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public LinkedList<NodeManager> createNodeManagers() {
        Collection<Property> properties = this.configuration.getProperties();
        LinkedList<NodeManager> nodeManagers = new LinkedList<NodeManager>();
        for (Property property : properties) {
            nodeManagers.add(new DefaultNodeManager(property));
        }
        nodeManagers.sort(Comparator.comparing(m -> m.property().level()));
        NodeManager tail = (NodeManager)nodeManagers.get(0);
        for (int i = 1; i < nodeManagers.size(); ++i) {
            DefaultNodeManager tail1 = (DefaultNodeManager)tail;
            DefaultNodeManager cur1 = (DefaultNodeManager)nodeManagers.get(i);
            tail1.setNext(cur1);
            cur1.setPrev(tail1);
            tail = cur1;
        }
        return nodeManagers;
    }
}

