/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.node;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import top.chitucao.summerframework.trie.node.ConcurrentHashMapNode;
import top.chitucao.summerframework.trie.node.ConcurrentSkipListMapNode;
import top.chitucao.summerframework.trie.node.HashMapNode;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.node.NodeFactory;
import top.chitucao.summerframework.trie.node.NodeType;
import top.chitucao.summerframework.trie.node.TreeMapNode;
import top.chitucao.summerframework.trie.node.extra.NamedHashMapNode;
import top.chitucao.summerframework.trie.node.extra.NamedTreeMapNode;

public class NodeFactoryRegistry {
    public static final NodeFactoryRegistry INSTANCE = new NodeFactoryRegistry();
    private final Map<String, NodeFactory> registry = new HashMap<String, NodeFactory>();

    public NodeFactoryRegistry() {
        this.registerBaseNodeFactories();
    }

    public static NodeFactoryRegistry getInstance() {
        return INSTANCE;
    }

    private void registerBaseNodeFactories() {
        this.registerNodeFactory(new NodeFactory(){

            @Override
            public NodeType nodeType() {
                return NodeType.HASH_MAP;
            }

            @Override
            public <K> Node<K> newNode() {
                return new HashMapNode();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren() {
                return new HashMap();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren(Map<K, Node<K>> childMap) {
                if (childMap == null || childMap.isEmpty()) {
                    return this.newChildren();
                }
                return new HashMap<K, Node<K>>(childMap);
            }
        });
        this.registerNodeFactory(new NodeFactory(){

            @Override
            public NodeType nodeType() {
                return NodeType.TREE_MAP;
            }

            @Override
            public <K> Node<K> newNode() {
                return new TreeMapNode();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren() {
                return new TreeMap();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren(Map<K, Node<K>> childMap) {
                if (childMap == null || childMap.isEmpty()) {
                    return this.newChildren();
                }
                return new TreeMap<K, Node<K>>(childMap);
            }
        });
        this.registerNodeFactory(new NodeFactory(){

            @Override
            public NodeType nodeType() {
                return NodeType.CONCURRENT_HASH_MAP;
            }

            @Override
            public <K> Node<K> newNode() {
                return new ConcurrentHashMapNode();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren() {
                return new ConcurrentHashMap();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren(Map<K, Node<K>> childMap) {
                if (childMap == null || childMap.isEmpty()) {
                    return this.newChildren();
                }
                return new ConcurrentHashMap<K, Node<K>>(childMap);
            }
        });
        this.registerNodeFactory(new NodeFactory(){

            @Override
            public NodeType nodeType() {
                return NodeType.CONCURRENT_SKIP_LIST_MAP;
            }

            @Override
            public <K> Node<K> newNode() {
                return new ConcurrentSkipListMapNode();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren() {
                return new ConcurrentSkipListMap();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren(Map<K, Node<K>> childMap) {
                if (childMap == null || childMap.isEmpty()) {
                    return this.newChildren();
                }
                return new ConcurrentSkipListMap<K, Node<K>>(childMap);
            }
        });
        this.registerNodeFactory(new NodeFactory(){

            @Override
            public NodeType nodeType() {
                return NodeType.NAMED_HASH_MAP;
            }

            @Override
            public <K> Node<K> newNode() {
                return new NamedHashMapNode();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren() {
                return new HashMap();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren(Map<K, Node<K>> childMap) {
                if (childMap == null || childMap.isEmpty()) {
                    return this.newChildren();
                }
                return new HashMap<K, Node<K>>(childMap);
            }
        });
        this.registerNodeFactory(new NodeFactory(){

            @Override
            public NodeType nodeType() {
                return NodeType.NAMED_TREE_MAP;
            }

            @Override
            public <K> Node<K> newNode() {
                return new NamedTreeMapNode();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren() {
                return new TreeMap();
            }

            @Override
            public <K> Map<K, Node<K>> newChildren(Map<K, Node<K>> childMap) {
                if (childMap == null || childMap.isEmpty()) {
                    return this.newChildren();
                }
                return new TreeMap<K, Node<K>>(childMap);
            }
        });
    }

    public void registerNodeFactory(NodeFactory nodeFactory) {
        this.registry.put(nodeFactory.nodeType().name(), nodeFactory);
    }

    public void registerNodeFactory(String nodeType, NodeFactory nodeFactory) {
        this.registry.put(nodeType, nodeFactory);
    }

    public NodeFactory getNodeFactory(String nodeType) {
        return this.registry.get(nodeType);
    }
}

