/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.nodemanager;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.node.NodeFactory;
import top.chitucao.summerframework.trie.node.NodeFactoryRegistry;
import top.chitucao.summerframework.trie.nodemanager.NodeManager;
import top.chitucao.summerframework.trie.operation.Func;
import top.chitucao.summerframework.trie.operation.Operation;
import top.chitucao.summerframework.trie.operation.OperationRegistry;
import top.chitucao.summerframework.trie.query.Aggregation;
import top.chitucao.summerframework.trie.query.Criterion;

public class DefaultNodeManager
implements NodeManager {
    protected NodeManager prev;
    protected NodeManager next;
    protected Property<?, ?, ?> property;

    public DefaultNodeManager(Property<?, ?, ?> property) {
        this.property = property;
    }

    @Override
    public NodeManager prev() {
        return this.prev;
    }

    @Override
    public NodeManager next() {
        return this.next;
    }

    public Property<?, ?, ?> property() {
        return this.property;
    }

    @Override
    public <K> Node<K> createNewNode() {
        return NodeFactoryRegistry.getInstance().getNodeFactory(this.property.nodeType()).newNode();
    }

    @Override
    public <R, K> Stream<R> mappingDictValues(Set<K> dictKeys) {
        return dictKeys.stream().map(dictKey -> this.property.nodeKey2FieldValue(dictKey));
    }

    @Override
    public <T, R, K> K mappingDictKey(T t) {
        Property<?, ?, ?> property1 = this.property;
        return (K)property1.mappingNodeKey(property1.mappingFieldValue(t));
    }

    @Override
    public <T, R, K> Node<K> addChildNode(Node<K> parent, T t) {
        Property<?, ?, ?> property1 = this.property;
        Object val = property1.mappingFieldValue(t);
        if (val == null) {
            throw new IllegalArgumentException("Cannot add child node with null value. Property: " + property1.name() + "Data: " + t.toString());
        }
        Supplier childSupplier = this.next() == null ? this::createNewNode : () -> this.next.createNewNode();
        Object dictKey = property1.mappingOrCreateNodeKey(val);
        if (property1.isDictProperty()) {
            property1.getDict().put(dictKey, val);
        }
        return parent.putChild(dictKey, childSupplier);
    }

    @Override
    public <T, R, K> void removeChildNode(Node<K> parent, T t) {
        Property<?, ?, ?> property1 = this.property;
        Object val = property1.mappingFieldValue(t);
        if (Objects.isNull(val)) {
            return;
        }
        parent.removeChild(property1.mappingNodeKey(val));
    }

    @Override
    public <K> void removeChild(Node<K> parent, K dictKey) {
        parent.removeChild(dictKey);
        if (this.property.isDictProperty()) {
            this.property.getDict().removeNodeKey(dictKey);
        }
    }

    @Override
    public <T, R, K> Node<K> findChildNode(Node<K> parent, T t) {
        Property<?, ?, ?> property1 = this.property;
        Object val = property1.mappingFieldValue(t);
        if (Objects.isNull(val)) {
            return null;
        }
        return parent.child(property1.mappingNodeKey(val));
    }

    @Override
    public <K> Map<K, Node<K>> searchAndAgg(Node<K> cur, Criterion criterion, Aggregation aggregation) {
        if (Objects.isNull(criterion) && Objects.isNull((Object)aggregation)) {
            return cur.children();
        }
        if (Objects.isNull((Object)aggregation)) {
            return this.search(cur, criterion);
        }
        Map<K, Node<K>> childMap = this.search(cur, criterion);
        if (childMap.isEmpty() || childMap.size() == 1) {
            return childMap;
        }
        NodeFactory nodeFactory = NodeFactoryRegistry.getInstance().getNodeFactory(this.property.nodeType());
        Map newChildren = nodeFactory.newChildren();
        if (newChildren instanceof NavigableMap) {
            switch (aggregation) {
                case MIN: {
                    Map.Entry minEntry = ((NavigableMap)childMap).firstEntry();
                    newChildren.put(minEntry.getKey(), minEntry.getValue());
                    return newChildren;
                }
                case MAX: {
                    Map.Entry maxEntry = ((NavigableMap)childMap).lastEntry();
                    newChildren.put(maxEntry.getKey(), maxEntry.getValue());
                    return newChildren;
                }
            }
            return childMap;
        }
        switch (aggregation) {
            case MIN: {
                Map.Entry<K, Node<K>> minEntry = null;
                for (Map.Entry<K, Node<K>> entry : childMap.entrySet()) {
                    if (minEntry != null && ((Comparable)entry.getKey()).compareTo(minEntry.getKey()) >= 0) continue;
                    minEntry = entry;
                }
                if (Objects.nonNull(minEntry)) {
                    newChildren.put(minEntry.getKey(), minEntry.getValue());
                }
                return newChildren;
            }
            case MAX: {
                Map.Entry<K, Node<K>> maxEntry = null;
                for (Map.Entry<K, Node<K>> entry : childMap.entrySet()) {
                    if (maxEntry != null && ((Comparable)entry.getKey()).compareTo(maxEntry.getKey()) <= 0) continue;
                    maxEntry = entry;
                }
                if (Objects.nonNull(maxEntry)) {
                    newChildren.put(maxEntry.getKey(), maxEntry.getValue());
                }
                return newChildren;
            }
        }
        return childMap;
    }

    @Override
    public <K> Map<K, Node<K>> search(Node<K> cur, Criterion criterion) {
        Map<K, Node<K>> result = cur.children();
        if (Objects.isNull(criterion)) {
            return result;
        }
        for (Map.Entry<String, Object> entry : criterion.getCriterion().entrySet()) {
            result = this.operate(result, entry);
        }
        return result;
    }

    @Override
    public <K> boolean contains(Node<K> cur, Criterion criterion) {
        Map<K, Node<K>> childMap = cur.children();
        if (Objects.isNull(criterion)) {
            return true;
        }
        for (Map.Entry<String, Object> entry : criterion.getCriterion().entrySet()) {
            if (!(childMap = this.operate(childMap, entry)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public <K> void slice(Node<K> cur, Criterion criterion) {
        if (Objects.isNull(criterion)) {
            return;
        }
        cur.setChildren(this.search(cur, criterion));
    }

    @Override
    public <K> void remove(Node<K> cur, Criterion criterion) {
        if (Objects.isNull(criterion)) {
            return;
        }
        for (K k : this.search(cur, criterion).keySet()) {
            cur.children().remove(k);
        }
    }

    public void setPrev(NodeManager prev) {
        this.prev = prev;
    }

    public void setNext(NodeManager next) {
        this.next = next;
    }

    public Property<?, ?, ?> getProperty() {
        return this.property;
    }

    public void setProperty(Property<?, ?, ?> property) {
        this.property = property;
    }

    private <K> Map<K, Node<K>> operate(Map childMap, Map.Entry<String, Object> operationEntry) {
        String operationName = operationEntry.getKey();
        if (Objects.equals(operationName, Operation.FUNC.getValue())) {
            return ((Func)operationEntry.getValue()).apply(childMap, this.property);
        }
        return OperationRegistry.getInstance().getOperate(this.property.nodeType(), operationEntry.getKey()).query(childMap, this.property, operationEntry.getValue());
    }
}

