/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.node.NodeFactoryRegistry;
import top.chitucao.summerframework.trie.operation.Operate;

public class BasicOperates {
    public static final Operate HASH_MAP_EQ_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map<Object, Node<Object>> result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        Node childNode = (Node)childMap.get(key);
        if (Objects.nonNull(childNode)) {
            result.put(key, childNode);
        }
        return result;
    };
    public static final Operate HASH_MAP_NE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (Objects.equals(entry.getKey(), key)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_GT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Comparable)entry.getKey()).compareTo(key) <= 0) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_GTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Comparable)entry.getKey()).compareTo(key) < 0) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_LT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Comparable)entry.getKey()).compareTo(key) >= 0) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_LTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (((Comparable)entry.getKey()).compareTo(key) > 0) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_BETWEEN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        List range = (List)key;
        Comparable left = (Comparable)range.get(0);
        Comparable right = (Comparable)range.get(1);
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.compareTo(right) > 0) {
                return childMap;
            }
            for (Map.Entry entry : childMap.entrySet()) {
                Comparable entryKey = (Comparable)entry.getKey();
                if (entryKey.compareTo(left) < 0 || entryKey.compareTo(right) > 0) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        } else if (Objects.nonNull(left)) {
            for (Map.Entry entry : childMap.entrySet()) {
                if (((Comparable)entry.getKey()).compareTo(left) < 0) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry entry : childMap.entrySet()) {
                if (((Comparable)entry.getKey()).compareTo(right) > 0) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    };
    public static final Operate HASH_MAP_IN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        Map<Object, Node<Object>> result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        if (keys.size() == 1) {
            Object key1 = keys.iterator().next();
            Node childNode = (Node)childMap.get(key1);
            if (Objects.nonNull(childNode)) {
                result.put(key1, childNode);
            }
            return result;
        }
        for (Map.Entry entry : childMap.entrySet()) {
            if (!keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), (Node<Object>)entry.getValue());
        }
        return result;
    };
    public static final Operate HASH_MAP_NIN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate NAVIGABLE_MAP_EQ_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map<Object, Node<Object>> result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        Node childNode = (Node)childMap.get(key);
        if (Objects.nonNull(childNode)) {
            result.put(key, childNode);
        }
        return result;
    };
    public static final Operate NAVIGABLE_MAP_NE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (Objects.equals(entry.getKey(), key)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };
    public static final Operate NAVIGABLE_MAP_GT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        NavigableMap result = ((NavigableMap)childMap).tailMap(key, false);
        return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
    };
    public static final Operate NAVIGABLE_MAP_GTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        NavigableMap result = ((NavigableMap)childMap).tailMap(key, true);
        return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
    };
    public static final Operate NAVIGABLE_MAP_LT_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        NavigableMap result = ((NavigableMap)childMap).headMap(key, false);
        return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
    };
    public static final Operate NAVIGABLE_MAP_LTE_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        NavigableMap result = ((NavigableMap)childMap).headMap(key, true);
        return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
    };
    public static final Operate NAVIGABLE_MAP_BETWEEN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        List range = (List)key;
        Comparable left = (Comparable)range.get(0);
        Comparable right = (Comparable)range.get(1);
        if (Objects.isNull(left) && Objects.isNull(right)) {
            return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(childMap);
        }
        if (Objects.nonNull(left) && Objects.nonNull(right)) {
            if (left.compareTo(right) > 0) {
                return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
            }
            NavigableMap result = ((NavigableMap)childMap).subMap(left, true, right, true);
            return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
        }
        if (Objects.nonNull(left)) {
            NavigableMap result = ((NavigableMap)childMap).tailMap(left, true);
            return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
        }
        NavigableMap result = ((NavigableMap)childMap).headMap(right, true);
        return NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren(result);
    };
    public static final Operate NAVIGABLE_MAP_IN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        TreeMap<Object, Node<Object>> result = new TreeMap<Object, Node<Object>>();
        if (keys.size() == 1) {
            Object key1 = keys.iterator().next();
            Node childNode = (Node)childMap.get(key1);
            if (Objects.nonNull(childNode)) {
                result.put(key1, childNode);
            }
            return result;
        }
        for (Map.Entry entry : childMap.entrySet()) {
            if (!keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), (Node<Object>)entry.getValue());
        }
        return result;
    };
    public static final Operate NAVIGABLE_MAP_NIN_OP = (childMap, property, value) -> {
        Object key = BasicOperates.mapperDictKey(property, value);
        if (childMap.isEmpty() || Objects.isNull(key)) {
            return childMap;
        }
        HashSet keys = new HashSet((List)key);
        if (keys.isEmpty()) {
            return childMap;
        }
        Map result = NodeFactoryRegistry.getInstance().getNodeFactory(property.nodeType()).newChildren();
        for (Map.Entry entry : childMap.entrySet()) {
            if (keys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    };

    public static <T, R, K> Object mapperDictKey(Property<T, R, K> property, Object value) {
        if (Objects.isNull(value)) {
            return value;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.isEmpty()) {
                return Collections.emptyList();
            }
            return values.stream().map(property::mappingNodeKey).collect(Collectors.toList());
        }
        return property.mappingNodeKey(value);
    }

    public static <T, R, K> R mapperDictValue(Property<?, ?, ?> property, K key) {
        return (R)property.nodeKey2FieldValue(key);
    }
}

