/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import top.chitucao.summerframework.trie.operation.Func;
import top.chitucao.summerframework.trie.operation.Operation;
import top.chitucao.summerframework.trie.query.Criterion;

public class Criteria {
    private String key;
    private final LinkedHashMap<String, Object> criterion = new LinkedHashMap();
    private final List<Criteria> criteriaChain;

    public Criteria() {
        this.criteriaChain = new ArrayList<Criteria>();
    }

    private Criteria(String key) {
        this.key = key;
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
    }

    private Criteria(List<Criteria> criteriaChain, String key) {
        this.key = key;
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria eq(Object value) {
        this.addCriterion(Operation.EQ.getValue(), value);
        return this;
    }

    public Criteria ne(Object value) {
        this.addCriterion(Operation.NE.getValue(), value);
        return this;
    }

    public Criteria gt(Object value) {
        this.addCriterion(Operation.GT.getValue(), value);
        return this;
    }

    public Criteria gte(Object value) {
        this.addCriterion(Operation.GTE.getValue(), value);
        return this;
    }

    public Criteria lt(Object value) {
        this.addCriterion(Operation.LT.getValue(), value);
        return this;
    }

    public Criteria lte(Object value) {
        this.addCriterion(Operation.LTE.getValue(), value);
        return this;
    }

    public Criteria between(Object value, Object secondValue) {
        this.addCriterion(Operation.BETWEEN.getValue(), Arrays.asList(value, secondValue));
        return this;
    }

    public Criteria in(Object ... values) {
        return this.in(Arrays.asList(values));
    }

    public Criteria in(Collection<?> values) {
        this.addCriterion(Operation.IN.getValue(), values);
        return this;
    }

    public Criteria nin(Object ... values) {
        return this.nin(Arrays.asList(values));
    }

    public Criteria nin(Collection<?> values) {
        this.addCriterion(Operation.NIN.getValue(), values);
        return this;
    }

    public Criteria match(String operation, Object value) {
        this.addCriterion(operation, value);
        return this;
    }

    public Criteria func(Func func) {
        this.addCriterion(Operation.FUNC.getValue(), func);
        return this;
    }

    public Map<String, Criterion> getAllCriterion() {
        HashMap<String, Criterion> allCriterionMap = new HashMap<String, Criterion>();
        for (Criteria criteria : this.criteriaChain) {
            Criterion criterion = allCriterionMap.getOrDefault(criteria.key, new Criterion());
            criterion.getCriterion().putAll(criteria.criterion);
            allCriterionMap.put(criteria.key, criterion);
        }
        return allCriterionMap;
    }

    public void addCriterion(String operation, Object value) {
        this.criterion.put(operation, value);
    }
}

