package top.chukongxiang.tools.file.mimetype;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * @author 楚孔响
 * @version 1.0
 * @date 2023/8/24 11:18
 */
public class MimeTypePool extends HashMap<String, String> {

    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public MimeTypePool() {
        this(1024);
    }

    private MimeTypePool(Map<String, String> map) {
        super(map);
    }

    public MimeTypePool(int initialCapacity) {
        this(initialCapacity, DEFAULT_LOAD_FACTOR);
    }

    private MimeTypePool(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.set("123", "application/vnd.lotus-1-2-3");
        this.set("3dml", "text/vnd.in3d.3dml");
        this.set("3ds", "image/x-3ds");
        this.set("3g2", "video/3gpp2");
        this.set("3gp", "video/3gpp");
        this.set("7z", "application/x-7z-compressed");
        this.set("aab", "application/x-authorware-bin");
        this.set("aac", "audio/x-aac");
        this.set("aam", "application/x-authorware-map");
        this.set("aas", "application/x-authorware-seg");
        this.set("abw", "application/x-abiword");
        this.set("ac", "application/pkix-attr-cert");
        this.set("acc", "application/vnd.americandynamics.acc");
        this.set("ace", "application/x-ace-compressed");
        this.set("acu", "application/vnd.acucobol");
        this.set("acutc", "application/vnd.acucorp");
        this.set("adp", "audio/adpcm");
        this.set("aep", "application/vnd.audiograph");
        this.set("afm", "application/x-font-type1");
        this.set("afp", "application/vnd.ibm.modcap");
        this.set("ahead", "application/vnd.ahead.space");
        this.set("ai", "application/postscript");
        this.set("aif", "audio/x-aiff");
        this.set("aifc", "audio/x-aiff");
        this.set("aiff", "audio/x-aiff");
        this.set("air", "application/vnd.adobe.air-application-installer-package+zip");
        this.set("ait", "application/vnd.dvb.ait");
        this.set("ami", "application/vnd.amiga.ami");
        this.set("apk", "application/vnd.android.package-archive");
        this.set("application", "application/x-ms-application");
        this.set("apr", "application/vnd.lotus-approach");
        this.set("asf", "video/x-ms-asf");
        this.set("aso", "application/vnd.accpac.simply.aso");
        this.set("asx", "video/x-ms-asf");
        this.set("atc", "application/vnd.acucorp");
        this.set("atom", "application/atom+xml");
        this.set("atomcat", "application/atomcat+xml");
        this.set("atomsvc", "application/atomsvc+xml");
        this.set("atx", "application/vnd.antix.game-component");
        this.set("au", "audio/basic");
        this.set("avi", "video/x-msvideo");
        this.set("aw", "application/applixware");
        this.set("azf", "application/vnd.airzip.filesecure.azf");
        this.set("azs", "application/vnd.airzip.filesecure.azs");
        this.set("azw", "application/vnd.amazon.ebook");
        this.set("bat", "application/x-msdownload");
        this.set("bcpio", "application/x-bcpio");
        this.set("bdf", "application/x-font-bdf");
        this.set("bdm", "application/vnd.syncml.dm+wbxml");
        this.set("bed", "application/vnd.realvnc.bed");
        this.set("bh2", "application/vnd.fujitsu.oasysprs");
        this.set("bin", "application/octet-stream");
        this.set("bmi", "application/vnd.bmi");
        this.set("bmp", "image/bmp");
        this.set("book", "application/vnd.framemaker");
        this.set("box", "application/vnd.previewsystems.box");
        this.set("boz", "application/x-bzip2");
        this.set("bpk", "application/octet-stream");
        this.set("btif", "image/prs.btif");
        this.set("bz", "application/x-bzip");
        this.set("bz2", "application/x-bzip2");
        this.set("c", "text/x-c");
        this.set("c4d", "application/vnd.clonk.c4group");
        this.set("c4f", "application/vnd.clonk.c4group");
        this.set("c4g", "application/vnd.clonk.c4group");
        this.set("c4p", "application/vnd.clonk.c4group");
        this.set("c4u", "application/vnd.clonk.c4group");
        this.set("cab", "application/vnd.ms-cab-compressed");
        this.set("car", "application/vnd.curl.car");
        this.set("cat", "application/vnd.ms-pki.seccat");
        this.set("cc", "text/x-c");
        this.set("cct", "application/x-director");
        this.set("ccxml", "application/ccxml+xml");
        this.set("cdbcmsg", "application/vnd.contact.cmsg");
        this.set("cdf", "application/x-netcdf");
        this.set("cdkey", "application/vnd.mediastation.cdkey");
        this.set("cdmia", "application/cdmi-capability");
        this.set("cdmic", "application/cdmi-container");
        this.set("cdmid", "application/cdmi-domain");
        this.set("cdmio", "application/cdmi-object");
        this.set("cdmiq", "application/cdmi-queue");
        this.set("cdx", "chemical/x-cdx");
        this.set("cdxml", "application/vnd.chemdraw+xml");
        this.set("cdy", "application/vnd.cinderella");
        this.set("cer", "application/pkix-cert");
        this.set("cgm", "image/cgm");
        this.set("chat", "application/x-chat");
        this.set("chm", "application/vnd.ms-htmlhelp");
        this.set("chrt", "application/vnd.kde.kchart");
        this.set("cif", "chemical/x-cif");
        this.set("cii", "application/vnd.anser-web-certificate-issue-initiation");
        this.set("cil", "application/vnd.ms-artgalry");
        this.set("cla", "application/vnd.claymore");
        this.set("class", "application/java-vm");
        this.set("css", "text/css");
        this.set("csv", "text/csv");
        this.set("cu", "application/cu-seeme");
        this.set("curl", "text/vnd.curl");
        this.set("cww", "application/prs.cww");
        this.set("dae", "model/vnd.collada+xml");
        this.set("daf", "application/vnd.mobius.daf");
        this.set("davmount", "application/davmount+xml");
        this.set("dcurl", "text/vnd.curl.dcurl");
        this.set("dd2", "application/vnd.oma.dd2+xml");
        this.set("ddd", "application/vnd.fujixerox.ddd");
        this.set("deb", "application/x-debian-package");
        this.set("der", "application/x-x509-ca-cert");
        this.set("dfac", "application/vnd.dreamfactory");
        this.set("dir", "application/x-director");
        this.set("dis", "application/vnd.mobius.dis");
        this.set("djvu", "image/vnd.djvu");
        this.set("dmg", "application/x-apple-diskimage");
        this.set("dna", "application/vnd.dna");
        this.set("doc", "application/msword");
        this.set("docm", "application/vnd.ms-word.document.macroenabled.12");
        this.set("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.set("dot", "application/msword");
        this.set("dotm", "application/vnd.ms-word.template.macroenabled.12");
        this.set("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        this.set("dp", "application/vnd.osgi.dp");
        this.set("dpg", "application/vnd.dpgraph");
        this.set("dra", "audio/vnd.dra");
        this.set("dsc", "text/prs.lines.tag");
        this.set("dssc", "application/dssc+der");
        this.set("dtb", "application/x-dtbook+xml");
        this.set("dtd", "application/xml-dtd");
        this.set("dts", "audio/vnd.dts");
        this.set("dtshd", "audio/vnd.dts.hd");
        this.set("dvi", "application/x-dvi");
        this.set("dwf", "model/vnd.dwf");
        this.set("dwg", "image/vnd.dwg");
        this.set("dxf", "image/vnd.dxf");
        this.set("dxp", "application/vnd.spotfire.dxp");
        this.set("ecelp4800", "audio/vnd.nuera.ecelp4800");
        this.set("ecelp7470", "audio/vnd.nuera.ecelp7470");
        this.set("ecelp9600", "audio/vnd.nuera.ecelp9600");
        this.set("edm", "application/vnd.novadigm.edm");
        this.set("edx", "application/vnd.novadigm.edx");
        this.set("efif", "application/vnd.picsel");
        this.set("ei6", "application/vnd.pg.osasli");
        this.set("eml", "message/rfc822");
        this.set("eol", "audio/vnd.digital-winds");
        this.set("eot", "application/vnd.ms-fontobject");
        this.set("eps", "application/postscript");
        this.set("es3", "application/vnd.eszigno3+xml");
        this.set("esf", "application/vnd.epson.esf");
        this.set("etx", "text/x-setext");
        this.set("exe", "application/x-msdownload");
        this.set("ext", "application/vnd.novadigm.ext");
        this.set("ez", "application/andrew-inset");
        this.set("ez2", "application/vnd.ezpix-album");
        this.set("ez3", "application/vnd.ezpix-package");
        this.set("f", "text/x-fortran");
        this.set("f4v", "video/x-f4v");
        this.set("fbs", "image/vnd.fastbidsheet");
        this.set("fcs", "application/vnd.isac.fcs");
        this.set("fdf", "application/vnd.fdf");
        this.set("fe_launch", "application/vnd.denovo.fcselayout-link");
        this.set("fg5", "application/vnd.fujitsu.oasysgp");
        this.set("fh", "image/x-freehand");
        this.set("fig", "application/x-xfig");
        this.set("fli", "video/x-fli");
        this.set("flo", "application/vnd.micrografx.flo");
        this.set("flv", "video/x-flv");
        this.set("flw", "application/vnd.kde.kivio");
        this.set("flx", "text/vnd.fmi.flexstor");
        this.set("fly", "text/vnd.fly");
        this.set("fm", "application/vnd.framemaker");
        this.set("fnc", "application/vnd.frogans.fnc");
        this.set("fpx", "image/vnd.fpx");
        this.set("fsc", "application/vnd.fsc.weblaunch");
        this.set("fst", "image/vnd.fst");
        this.set("ftc", "application/vnd.fluxtime.clip");
        this.set("fti", "application/vnd.anser-web-funds-transfer-initiation");
        this.set("fvt", "video/vnd.fvt");
        this.set("fxp", "application/vnd.adobe.fxp");
        this.set("fzs", "application/vnd.fuzzysheet");
        this.set("g2w", "application/vnd.geoplan");
        this.set("g3", "image/g3fax");
        this.set("g3w", "application/vnd.geospace");
        this.set("gac", "application/vnd.groove-account");
        this.set("gdl", "model/vnd.gdl");
        this.set("geo", "application/vnd.dynageo");
        this.set("gex", "application/vnd.geometry-explorer");
        this.set("ggb", "application/vnd.geogebra.file");
        this.set("ggt", "application/vnd.geogebra.tool");
        this.set("ghf", "application/vnd.groove-help");
        this.set("gif", "image/gif");
        this.set("gim", "application/vnd.groove-identity-message");
        this.set("gmx", "application/vnd.gmx");
        this.set("gnumeric", "application/x-gnumeric");
        this.set("gph", "application/vnd.flographit");
        this.set("gqf", "application/vnd.grafeq");
        this.set("gqs", "application/vnd.grafeq");
        this.set("gram", "application/srgs");
        this.set("gre", "application/vnd.geometry-explorer");
        this.set("grv", "application/vnd.groove-injector");
        this.set("grxml", "application/srgs+xml");
        this.set("gsf", "application/x-font-ghostscript");
        this.set("gtar", "application/x-gtar");
        this.set("gtm", "application/vnd.groove-tool-message");
        this.set("gtw", "model/vnd.gtw");
        this.set("gv", "text/vnd.graphviz");
        this.set("gxt", "application/vnd.geonext");
        this.set("gz", "application/x-gzip");
        this.set("h", "text/x-c");
        this.set("h261", "video/h261");
        this.set("h263", "video/h263");
        this.set("h264", "video/h264");
        this.set("hbci", "application/vnd.hbci");
        this.set("hdf", "application/x-hdf");
        this.set("hh", "text/x-c");
        this.set("hlp", "application/winhlp");
        this.set("hpgl", "application/vnd.hp-hpgl");
        this.set("hpid", "application/vnd.hp-hpid");
        this.set("hps", "application/vnd.hp-hps");
        this.set("hqx", "application/mac-binhex40");
        this.set("htke", "application/vnd.kenameaapp");
        this.set("htm", "text/html");
        this.set("html", "text/html");
        this.set("hvd", "application/vnd.yamaha.hv-dic");
        this.set("hvp", "application/vnd.yamaha.hv-voice");
        this.set("hvs", "application/vnd.yamaha.hv-script");
        this.set("icc", "application/vnd.iccprofile");
        this.set("ice", "x-conference/x-cooltalk");
        this.set("icm", "application/vnd.iccprofile");
        this.set("ico", "image/x-icon");
        this.set("ics", "text/calendar");
        this.set("ief", "image/ief");
        this.set("ifb", "text/calendar");
        this.set("ifm", "application/vnd.shana.informed.formdata");
        this.set("iges", "model/iges");
        this.set("igl", "application/vnd.igloader");
        this.set("igm", "application/vnd.insors.igm");
        this.set("igs", "model/iges");
        this.set("igx", "application/vnd.micrografx.igx");
        this.set("iif", "application/vnd.shana.informed.interchange");
        this.set("imp", "application/vnd.accpac.simply.imp");
        this.set("ims", "application/vnd.ms-ims");
        this.set("in", "text/plain");
        this.set("ipfix", "application/ipfix");
        this.set("ipk", "application/vnd.shana.informed.package");
        this.set("irm", "application/vnd.ibm.rights-management");
        this.set("irp", "application/vnd.irepository.package+xml");
        this.set("itp", "application/vnd.shana.informed.formtemplate");
        this.set("ivp", "application/vnd.immervision-ivp");
        this.set("ivu", "application/vnd.immervision-ivu");
        this.set("jad", "text/vnd.sun.j2me.app-descriptor");
        this.set("jam", "application/vnd.jam");
        this.set("jar", "application/java-archive");
        this.set("java", "text/x-java-source");
        this.set("jisp", "application/vnd.jisp");
        this.set("jlt", "application/vnd.hp-jlyt");
        this.set("jnlp", "application/x-java-jnlp-file");
        this.set("joda", "application/vnd.joost.joda-archive");
        this.set("jpe", "image/jpeg");
        this.set("jpeg", "image/jpeg");
        this.set("jpg", "image/jpeg");
        this.set("jpgm", "video/jpm");
        this.set("jpgv", "video/jpeg");
        this.set("jpm", "video/jpm");
        this.set("js", "application/javascript");
        this.set("json", "application/json");
        this.set("kar", "audio/midi");
        this.set("karbon", "application/vnd.kde.karbon");
        this.set("kfo", "application/vnd.kde.kformula");
        this.set("kia", "application/vnd.kidspiration");
        this.set("kml", "application/vnd.google-earth.kml+xml");
        this.set("kmz", "application/vnd.google-earth.kmz");
        this.set("kne", "application/vnd.kinar");
        this.set("knp", "application/vnd.kinar");
        this.set("kon", "application/vnd.kde.kontour");
        this.set("kpr", "application/vnd.kde.kpresenter");
        this.set("kpt", "application/vnd.kde.kpresenter");
        this.set("kpxx", "application/vnd.ds-keypoint");
        this.set("ksp", "application/vnd.kde.kspread");
        this.set("ktr", "application/vnd.kahootz");
        this.set("ktx", "image/ktx");
        this.set("ktz", "application/vnd.kahootz");
        this.set("kwd", "application/vnd.kde.kword");
        this.set("kwt", "application/vnd.kde.kword");
        this.set("lasxml", "application/vnd.las.las+xml");
        this.set("latex", "application/x-latex");
        this.set("lbd", "application/vnd.llamagraphics.life-balance.desktop");
        this.set("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
        this.set("les", "application/vnd.hhe.lesson-player");
        this.set("lha", "application/octet-stream");
        this.set("link66", "application/vnd.route66.link66+xml");
        this.set("list", "text/plain");
        this.set("list3820", "application/vnd.ibm.modcap");
        this.set("listafp", "application/vnd.ibm.modcap");
        this.set("lnk", "application/x-ms-shortcut");
        this.set("log", "text/plain");
        this.set("lostxml", "application/lost+xml");
        this.set("lrf", "application/octet-stream");
        this.set("lrm", "application/vnd.ms-lrm");
        this.set("ltf", "application/vnd.frogans.ltf");
        this.set("lvp", "audio/vnd.lucent.voice");
        this.set("lwp", "application/vnd.lotus-wordpro");
        this.set("lzh", "application/octet-stream");
        this.set("m13", "application/x-msmediaview");
        this.set("m14", "application/x-msmediaview");
        this.set("m1v", "video/mpeg");
        this.set("m21", "application/mp21");
        this.set("m2a", "audio/mpeg");
        this.set("m2v", "video/mpeg");
        this.set("m3a", "audio/mpeg");
        this.set("m3u", "audio/x-mpegurl");
        this.set("m3u8", "application/vnd.apple.mpegurl");
        this.set("m4a", "audio/mp4");
        this.set("m4b", "audio/mp4");
        this.set("m4r", "audio/mp4");
        this.set("m4u", "video/vnd.mpegurl");
        this.set("m4v", "video/mp4");
        this.set("ma", "application/mathematica");
        this.set("mac", "image/x-macpaint");
        this.set("mads", "application/mads+xml");
        this.set("mag", "application/vnd.ecowin.chart");
        this.set("maker", "application/vnd.framemaker");
        this.set("man", "text/troff");
        this.set("mar", "application/octet-stream");
        this.set("mathml", "application/mathml+xml");
        this.set("mb", "application/mathematica");
        this.set("mbk", "application/vnd.mobius.mbk");
        this.set("mbox", "application/mbox");
        this.set("mc1", "application/vnd.medcalcdata");
        this.set("mcd", "application/vnd.mcd");
        this.set("mcurl", "text/vnd.curl.mcurl");
        this.set("mdb", "application/x-msaccess");
        this.set("mdi", "image/vnd.ms-modi");
        this.set("me", "text/troff");
        this.set("mesh", "model/mesh");
        this.set("meta4", "application/metalink4+xml");
        this.set("metalink", "application/metalink+xml");
        this.set("mets", "application/mets+xml");
        this.set("mfm", "application/vnd.mfmp");
        this.set("mft", "application/rpki-manifest");
        this.set("mgp", "application/vnd.osgeo.mapguide.package");
        this.set("mgz", "application/vnd.proteus.magazine");
        this.set("mid", "audio/midi");
        this.set("midi", "audio/midi");
        this.set("mie", "application/x-mie");
        this.set("mif", "application/vnd.mif");
        this.set("mime", "message/rfc822");
        this.set("mj2", "video/mj2");
        this.set("mjp2", "video/mj2");
        this.set("mk3d", "video/x-matroska");
        this.set("mka", "audio/x-matroska");
        this.set("mks", "video/x-matroska");
        this.set("mkv", "video/x-matroska");
        this.set("mlp", "application/vnd.dolby.mlp");
        this.set("mmd", "application/vnd.chipnuts.karaoke-mmd");
        this.set("mmf", "application/vnd.smaf");
        this.set("mmr", "image/vnd.fujixerox.edmics-mmr");
        this.set("mng", "video/x-mng");
        this.set("mny", "application/x-msmoney");
        this.set("mobi", "application/x-mobipocket-ebook");
        this.set("mods", "application/mods+xml");
        this.set("mov", "video/quicktime");
        this.set("movie", "video/x-sgi-movie");
        this.set("mp1", "audio/mpeg");
        this.set("mp2", "audio/mpeg");
        this.set("mp21", "application/mp21");
        this.set("mp2a", "audio/mpeg");
        this.set("mp3", "audio/mpeg");
        this.set("mp4", "video/mp4");
        this.set("mp4a", "audio/mp4");
        this.set("mp4s", "application/mp4");
        this.set("mp4v", "video/mp4");
        this.set("mpc", "application/vnd.mophun.certificate");
        this.set("mpe", "video/mpeg");
        this.set("mpeg", "video/mpeg");
        this.set("mpg", "video/mpeg");
        this.set("mpg4", "video/mp4");
        this.set("mpga", "audio/mpeg");
        this.set("mpkg", "application/vnd.apple.installer+xml");
        this.set("mpm", "application/vnd.blueice.multipass");
        this.set("mpn", "application/vnd.mophun.application");
        this.set("mpp", "application/vnd.ms-project");
        this.set("mpt", "application/vnd.ms-project");
        this.set("mpy", "application/vnd.ibm.minipay");
        this.set("mqy", "application/vnd.mobius.mqy");
        this.set("mrc", "application/marc");
        this.set("mrcx", "application/marcxml+xml");
        this.set("ms", "text/troff");
        this.set("mscml", "application/mediaservercontrol+xml");
        this.set("mseed", "application/vnd.fdsn.mseed");
        this.set("mseq", "application/vnd.mseq");
        this.set("msf", "application/vnd.epson.msf");
        this.set("msh", "model/mesh");
        this.set("msi", "application/x-msdownload");
        this.set("msl", "application/vnd.mobius.msl");
        this.set("msty", "application/vnd.muvee.style");
        this.set("mts", "model/vnd.mts");
        this.set("mus", "application/vnd.musician");
        this.set("musicxml", "application/vnd.recordare.musicxml+xml");
        this.set("mvb", "application/x-msmediaview");
        this.set("mwf", "application/vnd.mfer");
        this.set("mxf", "application/mxf");
        this.set("mxl", "application/vnd.recordare.musicxml");
        this.set("mxml", "application/xv+xml");
        this.set("mxs", "application/vnd.triscape.mxs");
        this.set("mxu", "video/vnd.mpegurl");
        this.set("n-gage", "application/vnd.nokia.n-gage.symbian.install");
        this.set("n3", "text/n3");
        this.set("nb", "application/mathematica");
        this.set("nbp", "application/vnd.wolfram.player");
        this.set("nc", "application/x-netcdf");
        this.set("ncx", "application/x-dtbncx+xml");
        this.set("nfo", "text/x-nfo");
        this.set("ngdat", "application/vnd.nokia.n-gage.data");
        this.set("nitf", "application/vnd.nitf");
        this.set("nlu", "application/vnd.neurolanguage.nlu");
        this.set("nml", "application/vnd.enliven");
        this.set("nnd", "application/vnd.noblenet-directory");
        this.set("nns", "application/vnd.noblenet-sealer");
        this.set("nnw", "application/vnd.noblenet-web");
        this.set("npx", "image/vnd.net-fpx");
        this.set("nsc", "application/x-conference");
        this.set("nsf", "application/vnd.lotus-notes");
        this.set("ntf", "application/vnd.nitf");
        this.set("nzb", "application/x-nzb");
        this.set("oa2", "application/vnd.fujitsu.oasys2");
        this.set("oa3", "application/vnd.fujitsu.oasys3");
        this.set("oas", "application/vnd.fujitsu.oasys");
        this.set("obd", "application/x-msbinder");
        this.set("obj", "application/x-tgif");
        this.set("oda", "application/oda");
        this.set("odb", "application/vnd.oasis.opendocument.database");
        this.set("odc", "application/vnd.oasis.opendocument.chart");
        this.set("odf", "application/vnd.oasis.opendocument.formula");
        this.set("odft", "application/vnd.oasis.opendocument.formula-template");
        this.set("odg", "application/vnd.oasis.opendocument.graphics");
        this.set("odi", "application/vnd.oasis.opendocument.image");
        this.set("odm", "application/vnd.oasis.opendocument.text-master");
        this.set("odp", "application/vnd.oasis.opendocument.presentation");
        this.set("ods", "application/vnd.oasis.opendocument.spreadsheet");
        this.set("odt", "application/vnd.oasis.opendocument.text");
        this.set("oga", "audio/ogg");
        this.set("ogg", "audio/ogg");
        this.set("ogv", "video/ogg");
        this.set("ogx", "application/ogg");
        this.set("omdoc", "application/omdoc+xml");
        this.set("onepkg", "application/onenote");
        this.set("onetmp", "application/onenote");
        this.set("onetoc", "application/onenote");
        this.set("onetoc2", "application/onenote");
        this.set("opf", "application/oebps-package+xml");
        this.set("opml", "text/x-opml");
        this.set("oprc", "application/vnd.palm");
        this.set("org", "application/vnd.lotus-organizer");
        this.set("osf", "application/vnd.yamaha.openscoreformat");
        this.set("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
        this.set("otc", "application/vnd.oasis.opendocument.chart-template");
        this.set("otf", "application/x-font-otf");
        this.set("otg", "application/vnd.oasis.opendocument.graphics-template");
        this.set("oth", "application/vnd.oasis.opendocument.text-web");
        this.set("oti", "application/vnd.oasis.opendocument.image-template");
        this.set("otp", "application/vnd.oasis.opendocument.presentation-template");
        this.set("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
        this.set("ott", "application/vnd.oasis.opendocument.text-template");
        this.set("oxps", "application/oxps");
        this.set("oxt", "application/vnd.openofficeorg.extension");
        this.set("p", "text/x-pascal");
        this.set("p10", "application/pkcs10");
        this.set("p12", "application/x-pkcs12");
        this.set("p7b", "application/x-pkcs7-certificates");
        this.set("p7c", "application/pkcs7-mime");
        this.set("p7m", "application/pkcs7-mime");
        this.set("p7r", "application/x-pkcs7-certreqresp");
        this.set("p7s", "application/pkcs7-signature");
        this.set("p8", "application/pkcs8");
        this.set("pas", "text/x-pascal");
        this.set("paw", "application/vnd.pawaafile");
        this.set("pbd", "application/vnd.powerbuilder6");
        this.set("pbm", "image/x-portable-bitmap");
        this.set("pcap", "application/vnd.tcpdump.pcap");
        this.set("pcf", "application/x-font-pcf");
        this.set("pcl", "application/vnd.hp-pcl");
        this.set("pclxl", "application/vnd.hp-pclxl");
        this.set("pct", "image/x-pict");
        this.set("pcurl", "application/vnd.curl.pcurl");
        this.set("pcx", "image/x-pcx");
        this.set("pdb", "application/vnd.palm");
        this.set("pdf", "application/pdf");
        this.set("pfa", "application/x-font-type1");
        this.set("pfb", "application/x-font-type1");
        this.set("pfm", "application/x-font-type1");
        this.set("pfr", "application/font-tdpfr");
        this.set("pfx", "application/x-pkcs12");
        this.set("pgm", "image/x-portable-graymap");
        this.set("pgn", "application/x-chess-pgn");
        this.set("pgp", "application/pgp-encrypted");
        this.set("pic", "image/x-pict");
        this.set("pkg", "application/octet-stream");
        this.set("pki", "application/pkixcmp");
        this.set("pkipath", "application/pkix-pkipath");
        this.set("plb", "application/vnd.3gpp.pic-bw-large");
        this.set("plc", "application/vnd.mobius.plc");
        this.set("plf", "application/vnd.pocketlearn");
        this.set("pls", "application/pls+xml");
        this.set("pml", "application/vnd.ctc-posml");
        this.set("png", "image/png");
        this.set("pnm", "image/x-portable-anymap");
        this.set("portpkg", "application/vnd.macports.portpkg");
        this.set("pot", "application/vnd.ms-powerpoint");
        this.set("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
        this.set("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        this.set("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
        this.set("ppd", "application/vnd.cups-ppd");
        this.set("ppm", "image/x-portable-pixmap");
        this.set("pps", "application/vnd.ms-powerpoint");
        this.set("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
        this.set("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        this.set("ppt", "application/vnd.ms-powerpoint");
        this.set("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
        this.set("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        this.set("pqa", "application/vnd.palm");
        this.set("prc", "application/x-mobipocket-ebook");
        this.set("pre", "application/vnd.lotus-freelance");
        this.set("prf", "application/pics-rules");
        this.set("ps", "application/postscript");
        this.set("psb", "application/vnd.3gpp.pic-bw-small");
        this.set("psd", "image/vnd.adobe.photoshop");
        this.set("psf", "application/x-font-linux-psf");
        this.set("pskcxml", "application/pskc+xml");
        this.set("ptid", "application/vnd.pvi.ptid1");
        this.set("pub", "application/x-mspublisher");
        this.set("pvb", "application/vnd.3gpp.pic-bw-var");
        this.set("pwn", "application/vnd.3m.post-it-notes");
        this.set("pya", "audio/vnd.ms-playready.media.pya");
        this.set("pyv", "video/vnd.ms-playready.media.pyv");
        this.set("qam", "application/vnd.epson.quickanime");
        this.set("qbo", "application/vnd.intu.qbo");
        this.set("qfx", "application/vnd.intu.qfx");
        this.set("qps", "application/vnd.publishare-delta-tree");
        this.set("qt", "video/quicktime");
        this.set("qwd", "application/vnd.quark.quarkxpress");
        this.set("qwt", "application/vnd.quark.quarkxpress");
        this.set("qxb", "application/vnd.quark.quarkxpress");
        this.set("qxd", "application/vnd.quark.quarkxpress");
        this.set("qxl", "application/vnd.quark.quarkxpress");
        this.set("qxt", "application/vnd.quark.quarkxpress");
        this.set("ra", "audio/x-pn-realaudio");
        this.set("ram", "audio/x-pn-realaudio");
        this.set("rar", "application/x-rar-compressed");
        this.set("ras", "image/x-cmu-raster");
        this.set("rcprofile", "application/vnd.ipunplugged.rcprofile");
        this.set("rdf", "application/rdf+xml");
        this.set("rdz", "application/vnd.data-vision.rdz");
        this.set("rep", "application/vnd.businessobjects");
        this.set("res", "application/x-dtbresource+xml");
        this.set("rgb", "image/x-rgb");
        this.set("rif", "application/reginfo+xml");
        this.set("rip", "audio/vnd.rip");
        this.set("ris", "application/x-research-info-systems");
        this.set("rl", "application/resource-lists+xml");
        this.set("rlc", "image/vnd.fujixerox.edmics-rlc");
        this.set("rld", "application/resource-lists-diff+xml");
        this.set("rm", "application/vnd.rn-realmedia");
        this.set("rmi", "audio/midi");
        this.set("rmp", "audio/x-pn-realaudio-plugin");
        this.set("rms", "application/vnd.jcp.javame.midlet-rms");
        this.set("rmvb", "application/vnd.rn-realmedia-vbr");
        this.set("rnc", "application/relax-ng-compact-syntax");
        this.set("roa", "application/rpki-roa");
        this.set("roff", "text/troff");
        this.set("rp9", "application/vnd.cloanto.rp9");
        this.set("rpss", "application/vnd.nokia.radio-presets");
        this.set("rpst", "application/vnd.nokia.radio-preset");
        this.set("rq", "application/sparql-query");
        this.set("rs", "application/rls-services+xml");
        this.set("rsd", "application/rsd+xml");
        this.set("rss", "application/rss+xml");
        this.set("rtf", "application/rtf");
        this.set("rtx", "text/richtext");
        this.set("s", "text/x-asm");
        this.set("s3m", "audio/s3m");
        this.set("saf", "application/vnd.yamaha.smaf-audio");
        this.set("sbml", "application/sbml+xml");
        this.set("sc", "application/vnd.ibm.secure-container");
        this.set("scd", "application/x-msschedule");
        this.set("scm", "application/vnd.lotus-screencam");
        this.set("scq", "application/scvp-cv-request");
        this.set("scs", "application/scvp-cv-response");
        this.set("scurl", "text/vnd.curl.scurl");
        this.set("sda", "application/vnd.stardivision.draw");
        this.set("sdc", "application/vnd.stardivision.calc");
        this.set("sdd", "application/vnd.stardivision.impress");
        this.set("sdkd", "application/vnd.solent.sdkm+xml");
        this.set("sdkm", "application/vnd.solent.sdkm+xml");
        this.set("sdp", "application/sdp");
        this.set("sdw", "application/vnd.stardivision.writer");
        this.set("see", "application/vnd.seemail");
        this.set("seed", "application/vnd.fdsn.seed");
        this.set("sema", "application/vnd.sema");
        this.set("semd", "application/vnd.semd");
        this.set("semf", "application/vnd.semf");
        this.set("ser", "application/java-serialized-object");
        this.set("setpay", "application/set-payment-initiation");
        this.set("setreg", "application/set-registration-initiation");
        this.set("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
        this.set("sfs", "application/vnd.spotfire.sfs");
        this.set("sfv", "text/x-sfv");
        this.set("sgi", "image/sgi");
        this.set("sgl", "application/vnd.stardivision.writer-global");
        this.set("sgm", "text/sgml");
        this.set("sgml", "text/sgml");
        this.set("sh", "application/x-sh");
        this.set("shar", "application/x-shar");
        this.set("shf", "application/shf+xml");
        this.set("sid", "image/x-mrsid-image");
        this.set("sig", "application/pgp-signature");
        this.set("sil", "audio/silk");
        this.set("silo", "model/mesh");
        this.set("sis", "application/vnd.symbian.install");
        this.set("sisx", "application/vnd.symbian.install");
        this.set("sit", "application/x-stuffit");
        this.set("sitx", "application/x-stuffitx");
        this.set("skd", "application/vnd.koan");
        this.set("skm", "application/vnd.koan");
        this.set("skp", "application/vnd.koan");
        this.set("skt", "application/vnd.koan");
        this.set("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
        this.set("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
        this.set("slt", "application/vnd.epson.salt");
        this.set("sm", "application/vnd.stepmania.stepchart");
        this.set("smf", "application/vnd.stardivision.math");
        this.set("smi", "application/smil+xml");
        this.set("smil", "application/smil+xml");
        this.set("smv", "video/x-smv");
        this.set("smzip", "application/vnd.stepmania.package");
        this.set("snd", "audio/basic");
        this.set("snf", "application/x-font-snf");
        this.set("so", "application/octet-stream");
        this.set("spc", "application/x-pkcs7-certificates");
        this.set("spf", "application/vnd.yamaha.smaf-phrase");
        this.set("spl", "application/x-futuresplash");
        this.set("spot", "text/vnd.in3d.spot");
        this.set("spp", "application/scvp-vp-response");
        this.set("spq", "application/scvp-vp-request");
        this.set("spx", "audio/ogg");
        this.set("sql", "application/x-sql");
        this.set("src", "application/x-wais-source");
        this.set("srt", "application/x-subrip");
        this.set("sru", "application/sru+xml");
        this.set("srx", "application/sparql-results+xml");
        this.set("ssdl", "application/ssdl+xml");
        this.set("sse", "application/vnd.kodak-descriptor");
        this.set("ssf", "application/vnd.epson.ssf");
        this.set("ssml", "application/ssml+xml");
        this.set("st", "application/vnd.sailingtracker.track");
        this.set("stc", "application/vnd.sun.xml.calc.template");
        this.set("std", "application/vnd.sun.xml.draw.template");
        this.set("stf", "application/vnd.wt.stf");
        this.set("sti", "application/vnd.sun.xml.impress.template");
        this.set("stk", "application/hyperstudio");
        this.set("stl", "application/vnd.ms-pki.stl");
        this.set("str", "application/vnd.pg.format");
        this.set("stw", "application/vnd.sun.xml.writer.template");
        this.set("sub", "text/vnd.dvb.subtitle");
        this.set("sus", "application/vnd.sus-calendar");
        this.set("susp", "application/vnd.sus-calendar");
        this.set("sv4cpio", "application/x-sv4cpio");
        this.set("sv4crc", "application/x-sv4crc");
        this.set("svc", "application/vnd.dvb.service");
        this.set("svd", "application/vnd.svd");
        this.set("svg", "image/svg+xml");
        this.set("svgz", "image/svg+xml");
        this.set("swa", "application/x-director");
        this.set("swf", "application/x-shockwave-flash");
        this.set("swi", "application/vnd.aristanetworks.swi");
        this.set("sxc", "application/vnd.sun.xml.calc");
        this.set("sxd", "application/vnd.sun.xml.draw");
        this.set("sxg", "application/vnd.sun.xml.writer.global");
        this.set("sxi", "application/vnd.sun.xml.impress");
        this.set("sxm", "application/vnd.sun.xml.math");
        this.set("sxw", "application/vnd.sun.xml.writer");
        this.set("t", "text/troff");
        this.set("t3", "application/x-t3vm-image");
        this.set("taglet", "application/vnd.mynfc");
        this.set("tao", "application/vnd.tao.intent-module-archive");
        this.set("tar", "application/x-tar");
        this.set("tcap", "application/vnd.3gpp2.tcap");
        this.set("tcl", "application/x-tcl");
        this.set("teacher", "application/vnd.smart.teacher");
        this.set("tei", "application/tei+xml");
        this.set("teicorpus", "application/tei+xml");
        this.set("tex", "application/x-tex");
        this.set("texi", "application/x-texinfo");
        this.set("texinfo", "application/x-texinfo");
        this.set("text", "text/plain");
        this.set("tfi", "application/thraud+xml");
        this.set("tfm", "application/x-tex-tfm");
        this.set("tga", "image/x-tga");
        this.set("thmx", "application/vnd.ms-officetheme");
        this.set("tif", "image/tiff");
        this.set("tiff", "image/tiff");
        this.set("tmo", "application/vnd.tmobile-livetv");
        this.set("torrent", "application/x-bittorrent");
        this.set("tpl", "application/vnd.groove-tool-template");
        this.set("tpt", "application/vnd.trid.tpt");
        this.set("tr", "text/troff");
        this.set("tra", "application/vnd.trueapp");
        this.set("trm", "application/x-msterminal");
        this.set("tsd", "application/timestamped-data");
        this.set("tsv", "text/tab-separated-values");
        this.set("ttc", "application/x-font-ttf");
        this.set("ttf", "application/x-font-ttf");
        this.set("ttl", "text/turtle");
        this.set("twd", "application/vnd.simtech-mindmapper");
        this.set("twds", "application/vnd.simtech-mindmapper");
        this.set("txd", "application/vnd.genomatix.tuxedo");
        this.set("txf", "application/vnd.mobius.txf");
        this.set("txt", "text/plain");
        this.set("u32", "application/x-authorware-bin");
        this.set("udeb", "application/x-debian-package");
        this.set("ufd", "application/vnd.ufdl");
        this.set("ufdl", "application/vnd.ufdl");
        this.set("ulw", "audio/basic");
        this.set("ulx", "application/x-glulx");
        this.set("umj", "application/vnd.umajin");
        this.set("unityweb", "application/vnd.unity");
        this.set("uoml", "application/vnd.uoml+xml");
        this.set("uri", "text/uri-list");
        this.set("uris", "text/uri-list");
        this.set("urls", "text/uri-list");
        this.set("ustar", "application/x-ustar");
        this.set("utz", "application/vnd.uiq.theme");
        this.set("uu", "text/x-uuencode");
        this.set("uva", "audio/vnd.dece.audio");
        this.set("uvd", "application/vnd.dece.data");
        this.set("uvf", "application/vnd.dece.data");
        this.set("uvg", "image/vnd.dece.graphic");
        this.set("uvh", "video/vnd.dece.hd");
        this.set("uvi", "image/vnd.dece.graphic");
        this.set("uvm", "video/vnd.dece.mobile");
        this.set("uvp", "video/vnd.dece.pd");
        this.set("uvs", "video/vnd.dece.sd");
        this.set("uvt", "application/vnd.dece.ttml+xml");
        this.set("uvu", "video/vnd.uvvu.mp4");
        this.set("uvv", "video/vnd.dece.video");
        this.set("uvva", "audio/vnd.dece.audio");
        this.set("uvvd", "application/vnd.dece.data");
        this.set("uvvf", "application/vnd.dece.data");
        this.set("uvvg", "image/vnd.dece.graphic");
        this.set("uvvh", "video/vnd.dece.hd");
        this.set("uvvi", "image/vnd.dece.graphic");
        this.set("uvvm", "video/vnd.dece.mobile");
        this.set("uvvp", "video/vnd.dece.pd");
        this.set("uvvs", "video/vnd.dece.sd");
        this.set("uvvt", "application/vnd.dece.ttml+xml");
        this.set("uvvu", "video/vnd.uvvu.mp4");
        this.set("uvvv", "video/vnd.dece.video");
        this.set("uvvx", "application/vnd.dece.unspecified");
        this.set("uvvz", "application/vnd.dece.zip");
        this.set("uvx", "application/vnd.dece.unspecified");
        this.set("uvz", "application/vnd.dece.zip");
        this.set("vcard", "text/vcard");
        this.set("vcd", "application/x-cdlink");
        this.set("vcf", "text/x-vcard");
        this.set("vcg", "application/vnd.groove-vcard");
        this.set("vcs", "text/x-vcalendar");
        this.set("vcx", "application/vnd.vcx");
        this.set("vis", "application/vnd.visionary");
        this.set("viv", "video/vnd.vivo");
        this.set("vob", "video/x-ms-vob");
        this.set("vor", "application/vnd.stardivision.writer");
        this.set("vox", "application/x-authorware-bin");
        this.set("vrml", "model/vrml");
        this.set("vsd", "application/vnd.visio");
        this.set("vsf", "application/vnd.vsf");
        this.set("vss", "application/vnd.visio");
        this.set("vst", "application/vnd.visio");
        this.set("vsw", "application/vnd.visio");
        this.set("vtu", "model/vnd.vtu");
        this.set("vxml", "application/voicexml+xml");
        this.set("w3d", "application/x-director");
        this.set("wad", "application/x-doom");
        this.set("wav", "audio/x-wav");
        this.set("wax", "audio/x-ms-wax");
        this.set("wbmp", "image/vnd.wap.wbmp");
        this.set("wbs", "application/vnd.criticaltools.wbs+xml");
        this.set("wbxml", "application/vnd.wap.wbxml");
        this.set("wcm", "application/vnd.ms-works");
        this.set("wdb", "application/vnd.ms-works");
        this.set("wdp", "image/vnd.ms-photo");
        this.set("weba", "audio/webm");
        this.set("webm", "video/webm");
        this.set("webp", "image/webp");
        this.set("wg", "application/vnd.pmi.widget");
        this.set("wgt", "application/widget");
        this.set("wks", "application/vnd.ms-works");
        this.set("wm", "video/x-ms-wm");
        this.set("wma", "audio/x-ms-wma");
        this.set("wmd", "application/x-ms-wmd");
        this.set("wmf", "application/x-msmetafile");
        this.set("wml", "text/vnd.wap.wml");
        this.set("wmlc", "application/vnd.wap.wmlc");
        this.set("wmls", "text/vnd.wap.wmlscript");
        this.set("wmlsc", "application/vnd.wap.wmlscriptc");
        this.set("wmv", "video/x-ms-wmv");
        this.set("wmx", "video/x-ms-wmx");
        this.set("wmz", "application/x-ms-wmz");
        this.set("woff", "application/x-font-woff");
        this.set("wpd", "application/vnd.wordperfect");
        this.set("wpl", "application/vnd.ms-wpl");
        this.set("wps", "application/vnd.ms-works");
        this.set("wqd", "application/vnd.wqd");
        this.set("wri", "application/x-mswrite");
        this.set("wrl", "model/vrml");
        this.set("wsdl", "application/wsdl+xml");
        this.set("wspolicy", "application/wspolicy+xml");
        this.set("wtb", "application/vnd.webturbo");
        this.set("wvx", "video/x-ms-wvx");
        this.set("x32", "application/x-authorware-bin");
        this.set("x3d", "model/x3d+xml");
        this.set("x3db", "model/x3d+binary");
        this.set("x3dbz", "model/x3d+binary");
        this.set("x3dv", "model/x3d+vrml");
        this.set("x3dvz", "model/x3d+vrml");
        this.set("x3dz", "model/x3d+xml");
        this.set("xaml", "application/xaml+xml");
        this.set("xap", "application/x-silverlight-app");
        this.set("xar", "application/vnd.xara");
        this.set("xbap", "application/x-ms-xbap");
        this.set("xbd", "application/vnd.fujixerox.docuworks.binder");
        this.set("xbm", "image/x-xbitmap");
        this.set("xdf", "application/xcap-diff+xml");
        this.set("xdm", "application/vnd.syncml.dm+xml");
        this.set("xdp", "application/vnd.adobe.xdp+xml");
        this.set("xdssc", "application/dssc+xml");
        this.set("xdw", "application/vnd.fujixerox.docuworks");
        this.set("xenc", "application/xenc+xml");
        this.set("xer", "application/patch-ops-error+xml");
        this.set("xfdf", "application/vnd.adobe.xfdf");
        this.set("xfdl", "application/vnd.xfdl");
        this.set("xht", "application/xhtml+xml");
        this.set("xhtml", "application/xhtml+xml");
        this.set("xhvml", "application/xv+xml");
        this.set("xif", "image/vnd.xiff");
        this.set("xla", "application/vnd.ms-excel");
        this.set("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
        this.set("xlc", "application/vnd.ms-excel");
        this.set("xlf", "application/x-xliff+xml");
        this.set("xlm", "application/vnd.ms-excel");
        this.set("xls", "application/vnd.ms-excel");
        this.set("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
        this.set("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
        this.set("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.set("xlt", "application/vnd.ms-excel");
        this.set("xltm", "application/vnd.ms-excel.template.macroenabled.12");
        this.set("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        this.set("xlw", "application/vnd.ms-excel");
        this.set("xm", "audio/xm");
        this.set("xml", "application/xml");
        this.set("xo", "application/vnd.olpc-sugar");
        this.set("xop", "application/xop+xml");
        this.set("xpi", "application/x-xpinstall");
        this.set("xpl", "application/xproc+xml");
        this.set("xpm", "image/x-xpixmap");
        this.set("xpr", "application/vnd.is-xpr");
        this.set("xps", "application/vnd.ms-xpsdocument");
        this.set("xpw", "application/vnd.intercon.formnet");
        this.set("xpx", "application/vnd.intercon.formnet");
        this.set("xsl", "application/xml");
        this.set("xslt", "application/xslt+xml");
        this.set("xsm", "application/vnd.syncml+xml");
        this.set("xspf", "application/xspf+xml");
        this.set("xul", "application/vnd.mozilla.xul+xml");
        this.set("xvm", "application/xv+xml");
        this.set("xvml", "application/xv+xml");
        this.set("xwd", "image/x-xwindowdump");
        this.set("xyz", "chemical/x-xyz");
        this.set("xz", "application/x-xz");
        this.set("yang", "application/yang");
        this.set("yin", "application/yin+xml");
        this.set("z", "application/x-compress");
        this.set("z1", "application/x-zmachine");
        this.set("z2", "application/x-zmachine");
        this.set("z3", "application/x-zmachine");
        this.set("z4", "application/x-zmachine");
        this.set("z5", "application/x-zmachine");
        this.set("z6", "application/x-zmachine");
        this.set("z7", "application/x-zmachine");
        this.set("z8", "application/x-zmachine");
        this.set("zaz", "application/vnd.zzazz.deck+xml");
        this.set("zip", "application/zip");
        this.set("zir", "application/vnd.zul");
        this.set("zirz", "application/vnd.zul");
        this.set("zmm", "application/vnd.handheld-entertainment+xml");
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException("MimeTypePool is read-only");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException("MimeTypePool is read-only");
    }

    @Override
    public String putIfAbsent(String key, String value) {
        throw new UnsupportedOperationException("MimeTypePool is read-only");
    }

    @Override
    public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
        throw new UnsupportedOperationException("MimeTypePool is read-only");
    }

    @Override
    public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
        throw new UnsupportedOperationException("MimeTypePool is read-only");
    }

    private void set(String key, String value) {
        super.put(key, value);
    }
}
