/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.draw;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ClipMode;
import org.jetbrains.skia.Color;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FilterMipmap;
import org.jetbrains.skia.FilterMode;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.MipmapMode;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.PaintMode;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.SamplingMode;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.svg.SVGDOM;
import top.colter.mirai.plugin.bilibili.BiliConfig;
import top.colter.mirai.plugin.bilibili.ImageConfig;
import top.colter.mirai.plugin.bilibili.data.Theme;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n\u001a&\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u001a&\u0010!\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u001a.\u0010!\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u001a:\u0010%\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\n\u001a\u001a\u0010%\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010&\u001a\u00020$2\u0006\u0010,\u001a\u00020-\u001a4\u0010.\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r2\b\b\u0002\u0010\u001f\u001a\u00020 \u001a>\u00102\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r2\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u0010\u001f\u001a\u00020 \u001a\u0012\u00105\u001a\u00020\u0007*\u0002062\u0006\u0010+\u001a\u00020\n\u001a\u001a\u00107\u001a\u00020\u001c*\u00020\u00112\u0006\u0010/\u001a\u00020\r2\u0006\u00108\u001a\u00020\r\u001a\u0012\u00109\u001a\u00020\n*\u0002062\u0006\u0010:\u001a\u00020\u0001\u001a\u001a\u0010;\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r\u001a\u0012\u0010<\u001a\u00020\u0019*\u00020=2\u0006\u0010\u0012\u001a\u00020\u0001\u001a\n\u0010>\u001a\u00020\u001e*\u00020$\u001a\u0012\u0010>\u001a\u00020\u001e*\u00020$2\u0006\u0010?\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006@"}, d2={"emojiCharacter", "", "emojiRegex", "Lkotlin/text/Regex;", "getEmojiRegex", "()Lkotlin/text/Regex;", "generateLinearGradient", "", "colors", "", "", "hsb2rgb", "h", "", "s", "v", "loadSVG", "Lorg/jetbrains/skia/svg/SVGDOM;", "path", "rgb2hsb", "", "rgbR", "rgbG", "rgbB", "drawImageClip", "", "Lorg/jetbrains/skia/Canvas;", "image", "Lorg/jetbrains/skia/Image;", "dstRect", "Lorg/jetbrains/skia/RRect;", "paint", "Lorg/jetbrains/skia/Paint;", "drawImageRRect", "rRect", "srcRect", "Lorg/jetbrains/skia/Rect;", "drawRectShadowAntiAlias", "r", "dx", "dy", "blur", "spread", "color", "shadow", "Ltop/colter/mirai/plugin/bilibili/data/Theme$Shadow;", "drawScaleWidthImage", "width", "x", "y", "drawScaleWidthImageOutline", "isForward", "", "getRGB", "Lorg/jetbrains/skia/Color;", "makeImage", "height", "makeRGB", "hex", "offsetR", "saveImage", "Lorg/jetbrains/skia/Surface;", "toRRect", "radius", "bilibili-dynamic-mirai-plugin"})
public final class GeneralKt {
    @NotNull
    public static final String emojiCharacter = "(?:[\\uD83C\\uDF00-\\uD83D\\uDDFF]|[\\uD83E\\uDD00-\\uD83E\\uDDFF]|[\\uD83D\\uDE00-\\uD83D\\uDE4F]|[\\uD83D\\uDE80-\\uD83D\\uDEFF]|[\\u2600-\\u26FF]\\uFE0F?|[\\u2700-\\u27BF]\\uFE0F?|\\u24C2\\uFE0F?|[\\uD83C\\uDDE6-\\uD83C\\uDDFF]{1,2}|[\\uD83C\\uDD70\\uD83C\\uDD71\\uD83C\\uDD7E\\uD83C\\uDD7F\\uD83C\\uDD8E\\uD83C\\uDD91-\\uD83C\\uDD9A]\\uFE0F?|[\\u0023\\u002A\\u0030-\\u0039]\\uFE0F?\\u20E3|[\\u2194-\\u2199\\u21A9-\\u21AA]\\uFE0F?|[\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B50\\u2B55]\\uFE0F?|[\\u2934\\u2935]\\uFE0F?|[\\u3030\\u303D]\\uFE0F?|[\\u3297\\u3299]\\uFE0F?|[\\uD83C\\uDE01\\uD83C\\uDE02\\uD83C\\uDE1A\\uD83C\\uDE2F\\uD83C\\uDE32-\\uD83C\\uDE3A\\uD83C\\uDE50\\uD83C\\uDE51]\\uFE0F?|[\\u203C\\u2049]\\uFE0F?|[\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB-\\u25FE]\\uFE0F?|[\\u00A9\\u00AE]\\uFE0F?|[\\u2122\\u2139]\\uFE0F?|\\uD83C\\uDC04\\uFE0F?|\\uD83C\\uDCCF\\uFE0F?|[\\u231A\\u231B\\u2328\\u23CF\\u23E9-\\u23F3\\u23F8-\\u23FA]\\uFE0F?)(?:[\\uD83C\\uDFFB-\\uD83C\\uDFFF]|[\\uD83E\\uDDB0-\\uD83E\\uDDB3])?";
    @NotNull
    private static final Regex emojiRegex = new Regex("(?:[\\uD83C\\uDF00-\\uD83D\\uDDFF]|[\\uD83E\\uDD00-\\uD83E\\uDDFF]|[\\uD83D\\uDE00-\\uD83D\\uDE4F]|[\\uD83D\\uDE80-\\uD83D\\uDEFF]|[\\u2600-\\u26FF]\\uFE0F?|[\\u2700-\\u27BF]\\uFE0F?|\\u24C2\\uFE0F?|[\\uD83C\\uDDE6-\\uD83C\\uDDFF]{1,2}|[\\uD83C\\uDD70\\uD83C\\uDD71\\uD83C\\uDD7E\\uD83C\\uDD7F\\uD83C\\uDD8E\\uD83C\\uDD91-\\uD83C\\uDD9A]\\uFE0F?|[\\u0023\\u002A\\u0030-\\u0039]\\uFE0F?\\u20E3|[\\u2194-\\u2199\\u21A9-\\u21AA]\\uFE0F?|[\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B50\\u2B55]\\uFE0F?|[\\u2934\\u2935]\\uFE0F?|[\\u3030\\u303D]\\uFE0F?|[\\u3297\\u3299]\\uFE0F?|[\\uD83C\\uDE01\\uD83C\\uDE02\\uD83C\\uDE1A\\uD83C\\uDE2F\\uD83C\\uDE32-\\uD83C\\uDE3A\\uD83C\\uDE50\\uD83C\\uDE51]\\uFE0F?|[\\u203C\\u2049]\\uFE0F?|[\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB-\\u25FE]\\uFE0F?|[\\u00A9\\u00AE]\\uFE0F?|[\\u2122\\u2139]\\uFE0F?|\\uD83C\\uDC04\\uFE0F?|\\uD83C\\uDCCF\\uFE0F?|[\\u231A\\u231B\\u2328\\u23CF\\u23E9-\\u23F3\\u23F8-\\u23FA]\\uFE0F?)(?:[\\uD83C\\uDFFB-\\uD83C\\uDFFF]|[\\uD83E\\uDDB0-\\uD83E\\uDDB3])?(?:\\u200D(?:[\\uD83C\\uDF00-\\uD83D\\uDDFF]|[\\uD83E\\uDD00-\\uD83E\\uDDFF]|[\\uD83D\\uDE00-\\uD83D\\uDE4F]|[\\uD83D\\uDE80-\\uD83D\\uDEFF]|[\\u2600-\\u26FF]\\uFE0F?|[\\u2700-\\u27BF]\\uFE0F?|\\u24C2\\uFE0F?|[\\uD83C\\uDDE6-\\uD83C\\uDDFF]{1,2}|[\\uD83C\\uDD70\\uD83C\\uDD71\\uD83C\\uDD7E\\uD83C\\uDD7F\\uD83C\\uDD8E\\uD83C\\uDD91-\\uD83C\\uDD9A]\\uFE0F?|[\\u0023\\u002A\\u0030-\\u0039]\\uFE0F?\\u20E3|[\\u2194-\\u2199\\u21A9-\\u21AA]\\uFE0F?|[\\u2B05-\\u2B07\\u2B1B\\u2B1C\\u2B50\\u2B55]\\uFE0F?|[\\u2934\\u2935]\\uFE0F?|[\\u3030\\u303D]\\uFE0F?|[\\u3297\\u3299]\\uFE0F?|[\\uD83C\\uDE01\\uD83C\\uDE02\\uD83C\\uDE1A\\uD83C\\uDE2F\\uD83C\\uDE32-\\uD83C\\uDE3A\\uD83C\\uDE50\\uD83C\\uDE51]\\uFE0F?|[\\u203C\\u2049]\\uFE0F?|[\\u25AA\\u25AB\\u25B6\\u25C0\\u25FB-\\u25FE]\\uFE0F?|[\\u00A9\\u00AE]\\uFE0F?|[\\u2122\\u2139]\\uFE0F?|\\uD83C\\uDC04\\uFE0F?|\\uD83C\\uDCCF\\uFE0F?|[\\u231A\\u231B\\u2328\\u23CF\\u23E9-\\u23F3\\u23F8-\\u23FA]\\uFE0F?)(?:[\\uD83C\\uDFFB-\\uD83C\\uDFFF]|[\\uD83E\\uDDB0-\\uD83E\\uDDB3])?)*");

    @NotNull
    public static final Regex getEmojiRegex() {
        return emojiRegex;
    }

    @NotNull
    public static final Canvas drawRectShadowAntiAlias(@NotNull Canvas $this$drawRectShadowAntiAlias, @NotNull Rect r, float dx, float dy, float blur, float spread, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$drawRectShadowAntiAlias, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Rect insides = r.inflate(-1.0f);
        if (!insides.isEmpty()) {
            $this$drawRectShadowAntiAlias.save();
            if (insides instanceof RRect) {
                $this$drawRectShadowAntiAlias.clipRRect((RRect)insides, ClipMode.DIFFERENCE, true);
            } else {
                $this$drawRectShadowAntiAlias.clipRect(insides, ClipMode.DIFFERENCE, true);
            }
            $this$drawRectShadowAntiAlias.drawRectShadowNoclip(r, dx, dy, blur, spread, color2);
            $this$drawRectShadowAntiAlias.restore();
        } else {
            $this$drawRectShadowAntiAlias.drawRectShadowNoclip(r, dx, dy, blur, spread, color2);
        }
        return $this$drawRectShadowAntiAlias;
    }

    @NotNull
    public static final Canvas drawRectShadowAntiAlias(@NotNull Canvas $this$drawRectShadowAntiAlias, @NotNull Rect r, @NotNull Theme.Shadow shadow) {
        Intrinsics.checkNotNullParameter((Object)$this$drawRectShadowAntiAlias, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"shadow");
        return GeneralKt.drawRectShadowAntiAlias($this$drawRectShadowAntiAlias, r, shadow.getOffsetX(), shadow.getOffsetY(), shadow.getBlur(), shadow.getSpread(), shadow.getShadowColor());
    }

    public static final void drawImageRRect(@NotNull Canvas $this$drawImageRRect, @NotNull Image image, @NotNull Rect srcRect, @NotNull RRect rRect, @Nullable Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawImageRRect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)srcRect, (String)"srcRect");
        Intrinsics.checkNotNullParameter((Object)rRect, (String)"rRect");
        $this$drawImageRRect.save();
        $this$drawImageRRect.clipRRect(rRect, true);
        $this$drawImageRRect.drawImageRect(image, srcRect, (Rect)rRect, (SamplingMode)new FilterMipmap(FilterMode.LINEAR, MipmapMode.NEAREST), paint, true);
        $this$drawImageRRect.restore();
    }

    public static /* synthetic */ void drawImageRRect$default(Canvas canvas, Image image, Rect rect, RRect rRect, Paint paint, int n, Object object) {
        if ((n & 8) != 0) {
            paint = null;
        }
        GeneralKt.drawImageRRect(canvas, image, rect, rRect, paint);
    }

    public static final void drawImageRRect(@NotNull Canvas $this$drawImageRRect, @NotNull Image image, @NotNull RRect rRect, @Nullable Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawImageRRect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)rRect, (String)"rRect");
        GeneralKt.drawImageRRect($this$drawImageRRect, image, new Rect(0.0f, 0.0f, (float)image.getWidth(), (float)image.getHeight()), rRect, paint);
    }

    public static /* synthetic */ void drawImageRRect$default(Canvas canvas, Image image, RRect rRect, Paint paint, int n, Object object) {
        if ((n & 4) != 0) {
            paint = null;
        }
        GeneralKt.drawImageRRect(canvas, image, rRect, paint);
    }

    @NotNull
    public static final SVGDOM loadSVG(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SVGDOM(Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])top.colter.mirai.plugin.bilibili.utils.GeneralKt.loadResourceBytes(path), (int)0, (int)0, (int)6, null));
    }

    @NotNull
    public static final Image makeImage(@NotNull SVGDOM $this$makeImage, float width, float height) {
        Surface surface;
        Intrinsics.checkNotNullParameter((Object)$this$makeImage, (String)"<this>");
        $this$makeImage.setContainerSize(width, height);
        Surface $this$makeImage_u24lambda_u2d0 = surface = Surface.Companion.makeRasterN32Premul((int)width, (int)height);
        boolean bl = false;
        $this$makeImage.render($this$makeImage_u24lambda_u2d0.getCanvas());
        return surface.makeImageSnapshot();
    }

    public static final void saveImage(@NotNull Surface $this$saveImage, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$saveImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        Data data = Image.encodeToData$default((Image)$this$saveImage.makeImageSnapshot(), null, (int)0, (int)3, null);
        Intrinsics.checkNotNull((Object)data);
        FilesKt.writeBytes((File)file, (byte[])data.getBytes());
    }

    public static final void drawScaleWidthImage(@NotNull Canvas $this$drawScaleWidthImage, @NotNull Image image, float width, float x, float y, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawScaleWidthImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Rect src = Rect.Companion.makeXYWH(0.0f, 0.0f, (float)image.getWidth(), (float)image.getHeight());
        Rect dst = Rect.Companion.makeXYWH(x, y, width, width * (float)image.getHeight() / (float)image.getWidth());
        $this$drawScaleWidthImage.drawImageRect(image, src, dst, (SamplingMode)new FilterMipmap(FilterMode.LINEAR, MipmapMode.NEAREST), paint, true);
    }

    public static /* synthetic */ void drawScaleWidthImage$default(Canvas canvas, Image image, float f, float f2, float f3, Paint paint, int n, Object object) {
        if ((n & 0x10) != 0) {
            paint = new Paint();
        }
        GeneralKt.drawScaleWidthImage(canvas, image, f, f2, f3, paint);
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawScaleWidthImageOutline(@NotNull Canvas $this$drawScaleWidthImageOutline, @NotNull Image image, float width, float x, float y, boolean isForward, @NotNull Paint paint) {
        void $this$drawScaleWidthImageOutline_u24lambda_u2d1;
        Paint paint2;
        Intrinsics.checkNotNullParameter((Object)$this$drawScaleWidthImageOutline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        GeneralKt.drawScaleWidthImage($this$drawScaleWidthImageOutline, image, width, x, y, paint);
        RRect dst = GeneralKt.toRRect(Rect.Companion.makeXYWH(x, y, width, width * (float)image.getHeight() / (float)image.getWidth()));
        Paint paint3 = paint2 = new Paint();
        RRect rRect = dst;
        Canvas canvas = $this$drawScaleWidthImageOutline;
        boolean bl = false;
        $this$drawScaleWidthImageOutline_u24lambda_u2d1.setColor(isForward ? -16776961 : -16711936);
        $this$drawScaleWidthImageOutline_u24lambda_u2d1.setMode(PaintMode.STROKE);
        $this$drawScaleWidthImageOutline_u24lambda_u2d1.setStrokeWidth(2.0f);
        $this$drawScaleWidthImageOutline_u24lambda_u2d1.setAntiAlias(true);
        Unit unit = Unit.INSTANCE;
        canvas.drawRRect(rRect, paint2);
    }

    public static /* synthetic */ void drawScaleWidthImageOutline$default(Canvas canvas, Image image, float f, float f2, float f3, boolean bl, Paint paint, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            paint = new Paint();
        }
        GeneralKt.drawScaleWidthImageOutline(canvas, image, f, f2, f3, bl, paint);
    }

    @NotNull
    public static final RRect toRRect(@NotNull Rect $this$toRRect) {
        Intrinsics.checkNotNullParameter((Object)$this$toRRect, (String)"<this>");
        return RRect.Companion.makeLTRB($this$toRRect.getLeft(), $this$toRRect.getTop(), $this$toRRect.getRight(), $this$toRRect.getBottom(), 0.0f);
    }

    @NotNull
    public static final RRect toRRect(@NotNull Rect $this$toRRect, float radius) {
        Intrinsics.checkNotNullParameter((Object)$this$toRRect, (String)"<this>");
        return RRect.Companion.makeLTRB($this$toRRect.getLeft(), $this$toRRect.getTop(), $this$toRRect.getRight(), $this$toRRect.getBottom(), radius);
    }

    @NotNull
    public static final RRect offsetR(@NotNull RRect $this$offsetR, float dx, float dy) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetR, (String)"<this>");
        return RRect.Companion.makeComplexLTRB($this$offsetR.getLeft() + dx, $this$offsetR.getTop() + dy, $this$offsetR.getRight() + dx, $this$offsetR.getBottom() + dy, $this$offsetR.getRadii());
    }

    public static final void drawImageClip(@NotNull Canvas $this$drawImageClip, @NotNull Image image, @NotNull RRect dstRect, @Nullable Paint paint) {
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)$this$drawImageClip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)dstRect, (String)"dstRect");
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        if (dstRect.getWidth() / ratio < dstRect.getHeight()) {
            float imgW = dstRect.getWidth() * (float)image.getHeight() / dstRect.getHeight();
            float offsetX = ((float)image.getWidth() - imgW) / 2.0f;
            rect = Rect.Companion.makeXYWH(offsetX, 0.0f, imgW, (float)image.getHeight());
        } else {
            float imgH = dstRect.getHeight() * (float)image.getWidth() / dstRect.getWidth();
            float offsetY = ((float)image.getHeight() - imgH) / (float)2;
            rect = Rect.Companion.makeXYWH(0.0f, offsetY, (float)image.getWidth(), imgH);
        }
        Rect srcRect = rect;
        GeneralKt.drawImageRRect($this$drawImageClip, image, srcRect, dstRect, paint);
    }

    public static /* synthetic */ void drawImageClip$default(Canvas canvas, Image image, RRect rRect, Paint paint, int n, Object object) {
        if ((n & 4) != 0) {
            paint = null;
        }
        GeneralKt.drawImageClip(canvas, image, rRect, paint);
    }

    public static final int makeRGB(@NotNull Color $this$makeRGB, @NotNull String hex) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$makeRGB, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        if (!StringsKt.startsWith$default((String)hex, (String)"#", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-GeneralKt$makeRGB$32 = false;
            String $i$a$-require-GeneralKt$makeRGB$32 = "Hex format error: " + hex;
            throw new IllegalArgumentException($i$a$-require-GeneralKt$makeRGB$32.toString());
        }
        if (!(hex.length() == 7 || hex.length() == 9)) {
            boolean bl = false;
            String string = "Hex length error: " + hex;
            throw new IllegalArgumentException(string.toString());
        }
        switch (hex.length()) {
            case 7: {
                String string = hex.substring(1, 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n2 = Integer.valueOf(string, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(hex.substring(1, 3), 16)");
                int n3 = ((Number)n2).intValue();
                String string2 = hex.substring(3, 5);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n4 = Integer.valueOf(string2, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"valueOf(hex.substring(3, 5), 16)");
                int n5 = ((Number)n4).intValue();
                String string3 = hex.substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                Integer n6 = Integer.valueOf(string3, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n6, (String)"valueOf(hex.substring(5), 16)");
                n = $this$makeRGB.makeRGB(n3, n5, ((Number)n6).intValue());
                break;
            }
            case 9: {
                String string = hex.substring(1, 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n7 = Integer.valueOf(string, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"valueOf(hex.substring(1, 3), 16)");
                int n8 = ((Number)n7).intValue();
                String string4 = hex.substring(3, 5);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n9 = Integer.valueOf(string4, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n9, (String)"valueOf(hex.substring(3, 5), 16)");
                int n10 = ((Number)n9).intValue();
                String string5 = hex.substring(5, 7);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n11 = Integer.valueOf(string5, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n11, (String)"valueOf(hex.substring(5, 7), 16)");
                int n12 = ((Number)n11).intValue();
                String string6 = hex.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                Integer n13 = Integer.valueOf(string6, 16);
                Intrinsics.checkNotNullExpressionValue((Object)n13, (String)"valueOf(hex.substring(7), 16)");
                n = $this$makeRGB.makeARGB(n8, n10, n12, ((Number)n13).intValue());
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @NotNull
    public static final int[] getRGB(@NotNull Color $this$getRGB, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$getRGB, (String)"<this>");
        int[] nArray = new int[]{$this$getRGB.getR(color2), $this$getRGB.getG(color2), $this$getRGB.getB(color2)};
        return nArray;
    }

    @NotNull
    public static final float[] rgb2hsb(int rgbR, int rgbG, int rgbB) {
        int[] nArray = new int[]{rgbR, rgbG, rgbB};
        int[] rgb = nArray;
        Arrays.sort(rgb);
        int max = rgb[2];
        int min = rgb[0];
        float hsbB = (float)max / 255.0f;
        float hsbS = max == 0 ? 0.0f : (float)(max - min) / (float)max;
        float hsbH = 0.0f;
        if (max == rgbR && rgbG >= rgbB) {
            hsbH = (float)(rgbG - rgbB) * 60.0f / (float)(max - min) + 0.0f;
        } else if (max == rgbR && rgbG < rgbB) {
            hsbH = (float)(rgbG - rgbB) * 60.0f / (float)(max - min) + (float)360;
        } else if (max == rgbG) {
            hsbH = (float)(rgbB - rgbR) * 60.0f / (float)(max - min) + (float)120;
        } else if (max == rgbB) {
            hsbH = (float)(rgbR - rgbG) * 60.0f / (float)(max - min) + (float)240;
        }
        float[] fArray = new float[]{hsbH, hsbS, hsbB};
        return fArray;
    }

    @NotNull
    public static final int[] hsb2rgb(float h, float s, float v) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int i = (int)(h / (float)60 % (float)6);
        float f = h / (float)60 - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int[] nArray = new int[]{(int)((double)r * 255.0), (int)((double)g * 255.0), (int)((double)b * 255.0)};
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] generateLinearGradient(@NotNull List<Integer> colors) {
        int[] nArray;
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        ImageConfig.ColorGenerator colorGenerator = BiliConfig.INSTANCE.getImageConfig().getColorGenerator();
        if (colors.size() == 1) {
            float[] hsb = GeneralKt.rgb2hsb(Color.INSTANCE.getR(((Number)colors.get(0)).intValue()), Color.INSTANCE.getG(((Number)colors.get(0)).intValue()), Color.INSTANCE.getB(((Number)colors.get(0)).intValue()));
            if (colorGenerator.getLockSB()) {
                hsb[1] = colorGenerator.getSaturation();
                hsb[2] = colorGenerator.getBrightness();
            }
            int linearLayerCount = 3;
            int linearLayerStep = colorGenerator.getHueStep();
            int llc = linearLayerCount % 2 == 0 ? linearLayerCount + 1 : linearLayerCount;
            int[] ia = new int[llc];
            hsb[0] = (hsb[0] + (float)(linearLayerCount / 2 * linearLayerStep)) % (float)360;
            for (int i = 0; i < llc; ++i) {
                int it = i;
                boolean bl = false;
                int[] c = GeneralKt.hsb2rgb(hsb[0], hsb[1], hsb[2]);
                ia[it] = Color.INSTANCE.makeRGB(c[0], c[1], c[2]);
                hsb[0] = hsb[0] - (float)linearLayerStep < 0.0f ? hsb[0] + (float)360 - (float)linearLayerStep : hsb[0] - (float)linearLayerStep;
            }
            nArray = ia;
        } else {
            void var3_5;
            int llc = colors.size();
            int[] ia = new int[llc];
            for (int i = 0; i < llc; ++i) {
                int it = i;
                boolean bl = false;
                float[] hsb = GeneralKt.rgb2hsb(Color.INSTANCE.getR(((Number)colors.get(it)).intValue()), Color.INSTANCE.getG(((Number)colors.get(it)).intValue()), Color.INSTANCE.getB(((Number)colors.get(it)).intValue()));
                if (colorGenerator.getLockSB()) {
                    hsb[1] = colorGenerator.getSaturation();
                    hsb[2] = colorGenerator.getBrightness();
                }
                int[] c = GeneralKt.hsb2rgb(hsb[0], hsb[1], hsb[2]);
                ia[it] = Color.INSTANCE.makeRGB(c[0], c[1], c[2]);
            }
            nArray = var3_5;
        }
        return nArray;
    }
}

