/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.tasker;

import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.colter.mirai.plugin.bilibili.BiliConfig;
import top.colter.mirai.plugin.bilibili.CacheConfig;
import top.colter.mirai.plugin.bilibili.tasker.BiliTasker;
import top.colter.mirai.plugin.bilibili.utils.CacheType;
import top.colter.mirai.plugin.bilibili.utils.GeneralKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0012\u001a\u00020\u0013H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u00020\u0013*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R-\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n*\u0004\b\u0007\u0010\bR\u001a\u0010\r\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Ltop/colter/mirai/plugin/bilibili/tasker/CacheClearTasker;", "Ltop/colter/mirai/plugin/bilibili/tasker/BiliTasker;", "()V", "expires", "", "Ltop/colter/mirai/plugin/bilibili/utils/CacheType;", "", "getExpires$delegate", "(Ltop/colter/mirai/plugin/bilibili/tasker/CacheClearTasker;)Ljava/lang/Object;", "getExpires", "()Ljava/util/Map;", "expires$receiver", "Ltop/colter/mirai/plugin/bilibili/CacheConfig;", "interval", "getInterval", "()I", "setInterval", "(I)V", "main", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearExpireFile", "Ljava/nio/file/Path;", "expire", "bilibili-dynamic-mirai-plugin"})
public final class CacheClearTasker
extends BiliTasker {
    @NotNull
    public static final CacheClearTasker INSTANCE = new CacheClearTasker();
    private static int interval = 86400;
    @NotNull
    private static final CacheConfig expires$receiver = BiliConfig.INSTANCE.getCacheConfig();

    private CacheClearTasker() {
        super(null, 1, null);
    }

    @Override
    public int getInterval() {
        return interval;
    }

    @Override
    public void setInterval(int n) {
        interval = n;
    }

    private final Map<CacheType, Integer> getExpires() {
        return expires$receiver.getExpires();
    }

    private static Object getExpires$delegate(CacheClearTasker cacheClearTasker) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)expires$receiver, CacheConfig.class, "expires", "getExpires()Ljava/util/Map;", 0)));
    }

    @Override
    @Nullable
    protected Object main(@NotNull Continuation<? super Unit> $completion) {
        for (Map.Entry<CacheType, Integer> e : this.getExpires().entrySet()) {
            if (((Number)e.getValue()).intValue() <= 0) continue;
            this.clearExpireFile(GeneralKt.cachePath(e.getKey()), ((Number)e.getValue()).intValue());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearExpireFile(Path $this$clearExpireFile, int expire) {
        Path path = $this$clearExpireFile;
        Closeable closeable = Files.newDirectoryStream(path, "*");
        Throwable throwable = null;
        try {
            DirectoryStream directoryStream = (DirectoryStream)closeable;
            Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
            Iterable iterable = directoryStream;
            for (Path it : iterable) {
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    INSTANCE.clearExpireFile(it, expire);
                    continue;
                }
                if (System.currentTimeMillis() - it.toFile().lastModified() < (long)(expire * INSTANCE.getInterval() * 1000)) continue;
                it.toFile().delete();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

