/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.draw;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BlendMode;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Color;
import org.jetbrains.skia.ColorFilter;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.svg.SVGDOM;
import org.jetbrains.skiko.Convertors_jvmKt;
import top.colter.mirai.plugin.bilibili.draw.GeneralKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u000e"}, d2={"bgColor", "", "getBgColor", "()J", "pointColor", "getPointColor", "loginQrCode", "Lorg/jetbrains/skia/Image;", "url", "", "qrCode", "width", "", "color", "bilibili-dynamic-mirai-plugin"})
public final class QrCodeDrawKt {
    private static final long pointColor = 0xFF000000L;
    private static final long bgColor = 0xFFFFFFFFL;

    public static final long getPointColor() {
        return pointColor;
    }

    public static final long getBgColor() {
        return bgColor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Image loginQrCode(@NotNull String url) {
        void $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2;
        void $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d1;
        Paint $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d0;
        Paint paint;
        Canvas canvas;
        Surface surface;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)EncodeHintType.MARGIN, (Object)1), TuplesKt.to((Object)EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H)};
        BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, 250, 250, MapsKt.mapOf((Pair[])pairArray));
        MatrixToImageConfig config2 = new MatrixToImageConfig((int)pointColor, (int)bgColor);
        Surface $this$loginQrCode_u24lambda_u2d4 = surface = Surface.Companion.makeRasterN32Premul(250, 250);
        boolean bl = false;
        Canvas $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3 = canvas = $this$loginQrCode_u24lambda_u2d4.getCanvas();
        boolean bl2 = false;
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)config2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(bitMatrix, config)");
        Image img2 = Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap((BufferedImage)bufferedImage));
        $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3.drawImage(img2, 0.0f, 0.0f);
        Paint paint2 = paint = new Paint();
        float f = 35.0f;
        float f2 = 125.0f;
        float f3 = 125.0f;
        Canvas canvas2 = $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3;
        boolean bl3 = false;
        $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d0.setColor(-1);
        Unit unit = Unit.INSTANCE;
        canvas2.drawCircle(f3, f2, f, paint);
        $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d0 = paint = new Paint();
        f = 30.0f;
        f2 = 125.0f;
        f3 = 125.0f;
        canvas2 = $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3;
        boolean $i$a$-apply-QrCodeDrawKt$loginQrCode$1$1$42 = false;
        $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d1.setColor(Color.INSTANCE.makeRGB(2, 181, 218));
        unit = Unit.INSTANCE;
        canvas2.drawCircle(f3, f2, f, paint);
        SVGDOM svg = new SVGDOM(Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])top.colter.mirai.plugin.bilibili.utils.GeneralKt.loadResourceBytes("icon/BILIBILI_LOGO.svg"), (int)0, (int)0, (int)6, null));
        Paint $i$a$-apply-QrCodeDrawKt$loginQrCode$1$1$42 = paint2 = new Paint();
        f = 105.0f;
        f2 = 105.0f;
        Image image = GeneralKt.makeImage(svg, 40.0f, 40.0f);
        canvas2 = $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3;
        boolean bl4 = false;
        $this$loginQrCode_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.setColorFilter(ColorFilter.Companion.makeBlend(-1, BlendMode.SRC_ATOP));
        unit = Unit.INSTANCE;
        canvas2.drawImage(image, f2, f, paint2);
        return surface.makeImageSnapshot();
    }

    @NotNull
    public static final Image qrCode(@NotNull String url, int width, int color2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, width, width, MapsKt.mapOf((Pair)TuplesKt.to((Object)EncodeHintType.MARGIN, (Object)0)));
        int[] c = GeneralKt.getRGB(Color.INSTANCE, color2);
        int cc = c[0] + c[1] + c[2];
        if (cc > 382) {
            float[] hsb = GeneralKt.rgb2hsb(c[0], c[1], c[2]);
            float f = hsb[1] + 0.25f > 1.0f ? 1.0f : hsb[1] + 0.25f;
            hsb[1] = f;
            int[] rgb = GeneralKt.hsb2rgb(hsb[0], hsb[1], hsb[2]);
            n = Color.INSTANCE.makeRGB(rgb[0], rgb[1], rgb[2]);
        } else {
            n = color2;
        }
        int ccc = n;
        MatrixToImageConfig config2 = new MatrixToImageConfig(ccc, Color.INSTANCE.makeARGB(0, 255, 255, 255));
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix, (MatrixToImageConfig)config2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(bitMatrix, config)");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap((BufferedImage)bufferedImage));
    }
}

