/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.utils.translate;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J-\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0018\u0010\u0012\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0013H\u0086\u0002J(\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0018\u0010\u0012\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltop/colter/mirai/plugin/bilibili/utils/translate/HttpGet;", "", "()V", "GET", "", "SOCKET_TIMEOUT", "", "myX509TrustManager", "Ljavax/net/ssl/TrustManager;", "close", "", "closeable", "Ljava/io/Closeable;", "close$bilibili_dynamic_mirai_plugin", "encode", "input", "get", "host", "params", "", "getUrlWithQueryString", "url", "bilibili-dynamic-mirai-plugin"})
public final class HttpGet {
    @NotNull
    public static final HttpGet INSTANCE = new HttpGet();
    public static final int SOCKET_TIMEOUT = 10000;
    @NotNull
    public static final String GET = "GET";
    @NotNull
    private static final TrustManager myX509TrustManager = new X509TrustManager(){

        @Nullable
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }

        public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }
    };

    private HttpGet() {
    }

    @Nullable
    public final String get(@NotNull String host, @Nullable Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            sslcontext.init(null, trustManagerArray, null);
            String sendUrl = this.getUrlWithQueryString(host, params);
            URL uri = new URL(sendUrl);
            URLConnection uRLConnection = uri.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection conn = (HttpURLConnection)uRLConnection;
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslcontext.getSocketFactory());
            }
            conn.setConnectTimeout(10000);
            conn.setRequestMethod(GET);
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                System.out.println((Object)("Http\u9519\u8bef\u7801\uff1a" + statusCode));
            }
            InputStream is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while (true) {
                String string;
                String it = string = br.readLine();
                boolean bl = false;
                line = it;
                if (string == null) break;
                builder.append(line);
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            String text = string;
            this.close$bilibili_dynamic_mirai_plugin(br);
            this.close$bilibili_dynamic_mirai_plugin(is);
            conn.disconnect();
            return text;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    @NotNull
    public final String getUrlWithQueryString(@NotNull String url, @Nullable Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (params == null) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
            builder.append("&");
        } else {
            builder.append("?");
        }
        int i = 0;
        for (String key : params.keySet()) {
            String value;
            if (params.get(key) == null) continue;
            if (i != 0) {
                builder.append('&');
            }
            builder.append(key);
            builder.append('=');
            builder.append(this.encode(value));
            ++i;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public final void close$bilibili_dynamic_mirai_plugin(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final String encode(@Nullable String input) {
        if (input == null) {
            return "";
        }
        try {
            String string = URLEncoder.encode(input, "utf-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(input, \"utf-8\")");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return input;
        }
    }
}

