/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.utils.translate;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.colter.mirai.plugin.bilibili.utils.translate.HttpGet;
import top.colter.mirai.plugin.bilibili.utils.translate.MD5;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J \u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltop/colter/mirai/plugin/bilibili/utils/translate/TransApi;", "", "appid", "", "securityKey", "(Ljava/lang/String;Ljava/lang/String;)V", "buildParams", "", "query", "from", "to", "getTransResult", "Companion", "bilibili-dynamic-mirai-plugin"})
public final class TransApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String appid;
    @NotNull
    private final String securityKey;
    @NotNull
    private static final String TRANS_API_HOST = "http://api.fanyi.baidu.com/api/trans/vip/translate";

    public TransApi(@NotNull String appid, @NotNull String securityKey) {
        Intrinsics.checkNotNullParameter((Object)appid, (String)"appid");
        Intrinsics.checkNotNullParameter((Object)securityKey, (String)"securityKey");
        this.appid = appid;
        this.securityKey = securityKey;
    }

    @Nullable
    public final String getTransResult(@NotNull String query, @NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Map<String, String> params = this.buildParams(query, from, to);
        return HttpGet.INSTANCE.get(TRANS_API_HOST, params);
    }

    private final Map<String, String> buildParams(String query, String from, String to) {
        Map params = new HashMap();
        params.put("q", query);
        params.put("from", from);
        params.put("to", to);
        params.put("appid", this.appid);
        String salt = String.valueOf(System.currentTimeMillis());
        params.put("salt", salt);
        String src = this.appid + query + salt + this.securityKey;
        params.put("sign", MD5.INSTANCE.md5(src));
        return params;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltop/colter/mirai/plugin/bilibili/utils/translate/TransApi$Companion;", "", "()V", "TRANS_API_HOST", "", "bilibili-dynamic-mirai-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

