/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.utils.translate;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.colter.mirai.plugin.bilibili.BiliConfig;
import top.colter.mirai.plugin.bilibili.utils.GeneralKt;
import top.colter.mirai.plugin.bilibili.utils.JsonUtilsKt;
import top.colter.mirai.plugin.bilibili.utils.translate.TransApi;
import top.colter.mirai.plugin.bilibili.utils.translate.TransData;
import top.colter.mirai.plugin.bilibili.utils.translate.TransResult;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"api", "Ltop/colter/mirai/plugin/bilibili/utils/translate/TransApi;", "jp", "Lkotlin/text/Regex;", "getJp", "()Lkotlin/text/Regex;", "setJp", "(Lkotlin/text/Regex;)V", "trans", "", "text", "bilibili-dynamic-mirai-plugin"})
public final class TransApiKt {
    @NotNull
    private static Regex jp = new Regex("[\u3041\u3042\u3043\u3044\u3045\u3046\u3047\u3048\u3049\u304a\u304b\u304c\u304d\u304e\u304f\u3050\u3051\u3052\u3053\u3054\u3055\u3056\u3057\u3058\u3059\u305a\u305b\u305c\u305d\u305e\u305f\u3060\u3061\u3062\u3063\u3064\u3065\u3066\u3067\u3068\u3069\u306a\u306b\u306c\u306d\u306e\u306f\u3070\u3071\u3072\u3073\u3074\u3075\u3076\u3077\u3078\u3079\u307a\u307b\u307c\u307d\u307e\u307f\u3080\u3081\u3082\u3083\u3084\u3085\u3086\u3087\u3088\u3089\u308a\u308b\u308c\u308d\u308e\u308f\u3090\u3091\u3092\u3093\u3094\u3095\u3096\u309a\u309b\u309c\u309d\u309e\u309f\u30a0\u30a1\u30a2\u30a3\u30a4\u30a5\u30a6\u30a7\u30a8\u30a9\u30aa\u30ab\u30ac\u30ad\u30ae\u30af\u30b0\u30b1\u30b2\u30b3\u30b4\u30b5\u30b6\u30b7\u30b8\u30b9\u30ba\u30bb\u30bc\u30bd\u30be\u30bf\u30c0\u30c1\u30c2\u30c3\u30c4\u30c5\u30c6\u30c7\u30c8\u30c9\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d0\u30d1\u30d2\u30d3\u30d4\u30d5\u30d6\u30d7\u30d8\u30d9\u30da\u30db\u30dc\u30dd\u30de\u30df\u30e0\u30e1\u30e2\u30e3\u30e4\u30e5\u30e6\u30e7\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ee\u30ef\u30f0\u30f1\u30f2\u30f3\u30f4\u30f5\u30f6\u30f7\u30f8\u30f9\u30fa\u30fb\u30fc\u30fd\u30fe\u30ff\u337f]");
    @NotNull
    private static final TransApi api = new TransApi(BiliConfig.INSTANCE.getTranslateConfig().getBaidu().getAPP_ID(), BiliConfig.INSTANCE.getTranslateConfig().getBaidu().getSECURITY_KEY());

    @NotNull
    public static final Regex getJp() {
        return jp;
    }

    public static final void setJp(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        jp = regex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String trans(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!BiliConfig.INSTANCE.getEnableConfig().getTranslateEnable()) return null;
        if (!Intrinsics.areEqual((Object)BiliConfig.INSTANCE.getTranslateConfig().getBaidu().getSECURITY_KEY(), (Object)"")) {
            CharSequence charSequence;
            String msg = text;
            while (StringsKt.indexOf$default((CharSequence)msg, (char)'[', (int)0, (boolean)false, (int)6, null) != -1) {
                String string = msg;
                int n = StringsKt.indexOf$default((CharSequence)msg, (char)'[', (int)0, (boolean)false, (int)6, null);
                int n2 = StringsKt.indexOf$default((CharSequence)msg, (char)']', (int)0, (boolean)false, (int)6, null) + 1;
                CharSequence charSequence2 = "  ";
                msg = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n, (int)n2, (CharSequence)charSequence2)).toString();
            }
            CharSequence charSequence3 = msg;
            if (!jp.containsMatchIn(charSequence3) && new Regex("[\u4e00-\u9fa5]").containsMatchIn(charSequence = (CharSequence)msg)) return null;
            try {
                StringBuilder stringBuilder;
                String string = api.getTransResult(msg, "auto", "zh");
                if (string == null) {
                    GeneralKt.getLogger().error("\u7ffb\u8bd1\u6570\u636e\u83b7\u53d6\u5931\u8d25");
                    return null;
                }
                String it = string;
                boolean bl = false;
                TransResult transResult = (TransResult)JsonUtilsKt.getJson().decodeFromString((DeserializationStrategy)TransResult.Companion.serializer(), it);
                if (transResult.getErrorCode() != null) {
                    GeneralKt.getLogger().error("\u7ffb\u8bd1\u9519\u8bef code: " + transResult.getErrorCode() + "  msg: " + transResult.getErrorMsg());
                    return null;
                }
                if (Intrinsics.areEqual((Object)transResult.getFrom(), (Object)"zh")) return null;
                StringBuilder $this$trans_u24lambda_u241 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                List<TransData> list2 = transResult.getTransResult();
                Intrinsics.checkNotNull(list2);
                for (TransData item : list2) {
                    StringBuilder stringBuilder2 = $this$trans_u24lambda_u241.append(item.getDst());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                }
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                return string2;
            }
            catch (Exception exception) {
                GeneralKt.getLogger().error("Baidu translation failure! \u767e\u5ea6\u7ffb\u8bd1\u5931\u8d25! " + exception);
            }
            return null;
        }
        GeneralKt.getLogger().error("Baidu translation API not configured! \u672a\u914d\u7f6e\u767e\u5ea6\u7ffb\u8bd1API");
        return null;
    }
}

