/*
 * Decompiled with CFR 0.152.
 */
package top.colter.mirai.plugin.bilibili.utils.translate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ltop/colter/mirai/plugin/bilibili/utils/translate/MD5;", "", "()V", "hexDigits", "", "byteArrayToHex", "", "byteArray", "", "md5", "file", "Ljava/io/File;", "in", "Ljava/io/InputStream;", "input", "bilibili-dynamic-mirai-plugin"})
public final class MD5 {
    @NotNull
    public static final MD5 INSTANCE = new MD5();
    @NotNull
    private static final char[] hexDigits;

    private MD5() {
    }

    @Nullable
    public final String md5(@Nullable String input) {
        String string;
        if (input == null) {
            string = null;
        } else {
            String string2;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] inputByteArray = new byte[]{};
                try {
                    Charset charset = Charset.forName("utf-8");
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                    byte[] byArray = input.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    inputByteArray = byArray;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                messageDigest.update(inputByteArray);
                byte[] resultByteArray = messageDigest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)resultByteArray, (String)"resultByteArray");
                string2 = this.byteArrayToHex(resultByteArray);
            }
            catch (NoSuchAlgorithmException e) {
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    @Nullable
    public final String md5(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            if (!file.isFile()) {
                System.err.println("\u6587\u4ef6" + file.getAbsolutePath() + "\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u6587\u4ef6");
                return null;
            }
            FileInputStream in = new FileInputStream(file);
            String result = this.md5(in);
            in.close();
            return result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public final String md5(@NotNull InputStream in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int read = 0;
            while (true) {
                int n;
                int it = n = in.read(buffer);
                boolean bl = false;
                read = it;
                if (n == -1) break;
                messagedigest.update(buffer, 0, read);
            }
            in.close();
            byte[] byArray = messagedigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messagedigest.digest()");
            return this.byteArrayToHex(byArray);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private final String byteArrayToHex(byte[] byteArray) {
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[(byte)(b & 0xF)];
        }
        return new String(resultCharArray);
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        hexDigits = cArray;
    }
}

