package top.coos.app.session;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;

import com.alibaba.fastjson.JSONObject;

import top.coos.app.Application;
import top.coos.factory.LogFactory;

public class AppSession {

	static Logger log = LogFactory.get();

	private final HttpSession session;

	private final Application application;

	private boolean login;

	private String loginAccountId;

	private JSONObject account;

	private JSONObject cache;

	public AppSession(HttpSession session, Application application) {

		this.session = session;
		this.application = application;

		if (application != null) {
			application.triggerNewInstance(this);
		}
	}

	public String getLoginAccountId() {

		return loginAccountId;
	}

	public void setLoginAccountId(String loginAccountId) {

		this.loginAccountId = loginAccountId;
	}

	public HttpSession getSession() {

		return session;
	}

	public boolean isLogin() {

		return login;
	}

	public void doLogin(JSONObject account) {

		this.account = account;
		this.login = true;

		if (application != null) {
			application.triggerLogin(this);
		}
	}

	public void doLogout() {

		this.account = null;
		this.login = false;
		if (application != null) {
			application.triggerLogout(this);
		}
	}

	public JSONObject getAccount() {

		return account;
	}

	public Application getApplication() {

		return application;
	}

	public JSONObject getCache() {

		return cache;
	}

	public void setCache(JSONObject cache) {

		this.cache = cache;
	}

}
