package top.coos.app.context;

import top.coos.app.context.AppContext;
import top.coos.app.source.Source;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.resource.handler.ResourceHandler;

public class AppContextCache {

	public static Cache<String, AppContext> CACHE = CacheUtil.newCache();

	private static Object LOCK = new Object();

	public static AppContext get(String appid) {

		return CACHE.get(appid);
	}

	public static AppContext getOrLoad(String appid, Source source) {

		AppContext context = get(appid);
		if (context == null) {
			synchronized (LOCK) {
				context = get(appid);
				if (context == null) {
					try {
						if (source == null) {
							source = ResourceHandler.getBean(Source.class);
						}
						context = source.load(appid);
						set(appid, context);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}

			}
		}
		return context;
	}

	public static AppContext set(String appid, AppContext context) {

		CACHE.put(appid, context);
		return context;
	}
}
