package top.coos.app.factory;

import java.sql.SQLException;

import top.coos.app.Application;
import top.coos.bean.Database;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.db.ds.DSFactory;
import top.coos.service.Service;
import top.coos.service.dynamic.DynamicService;

public class ServiceFactory {

	final static Cache<String, DSFactory> DF_CACHE = CacheUtil.newCache();

	final static Cache<String, Database> DATABASE_CACHE = CacheUtil.newCache();

	private static String getFactoryKey(Database database) {

		String key = "";
		if (database != null) {
			key += database.getUrl();
			key += "-" + database.getName();
		}
		return key;
	}

	private static String getDatabaseKey(Application application, String name) {

		String key = "";
		if (application.getAppContext() != null && application.getAppContext().getProduct() != null) {
			key += application.getAppContext().getProduct().getId();
		}
		key += "-" + name;
		return key;
	}

	private static final DSFactory createDSFactory(Database database) throws SQLException {

		DSFactory factory = DSFactory.get(database);
		return factory;
	}

	public static final DSFactory getDSFactory(Database database) throws SQLException {

		String key = getFactoryKey(database);
		DSFactory factory = DF_CACHE.get(key);
		if (factory == null) {
			factory = createDSFactory(database);
		}
		DF_CACHE.put(key, factory);
		return factory;
	}

	public static final DSFactory get(Application application, String name) throws Exception {

		if (application == null) {
			throw new Exception("application is null.");
		}
		String key = getDatabaseKey(application, name);
		if (DATABASE_CACHE.get(key) == null) {
			Database database = application.getDatabaseByName(name);
			DATABASE_CACHE.put(key, database);
		}
		return getDSFactory(DATABASE_CACHE.get(key));
	}

	public static final Service getService(Application application, String name) throws Exception {

		return getService(get(application, name));
	}

	public static final Service getService(Database database) throws SQLException {

		return getService(getDSFactory(database));
	}

	public static final Service getService(DSFactory factory) {

		return new DynamicService(factory);
	}

}
