package top.coos.app.handler;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import top.coos.app.Application;
import top.coos.app.entity.AppEntity;
import top.coos.app.entity.ProductEntity;
import top.coos.app.entity.database.DatabaseEntity;
import top.coos.app.ifaces.IDatabaseFormater;
import top.coos.bean.Database;
import top.coos.db.config.DatabaseConfig;
import top.coos.util.StringUtil;

public class DatabaseHandler {

	public static void main(String[] args) {

	}

	public static Database get(Application application, String name) throws Exception {

		if (application != null) {
			Database database = application.getDatabaseByName(name);
			return database;
		}
		DatabaseEntity database = new DatabaseEntity();
		database.setName(name);
		return getRealDatabase(database, null);
	}

	public static Database getRealDatabase(DatabaseEntity databaseEntity, Application application)
			throws Exception {

		JSONObject object = new JSONObject();
		try {
			if (databaseEntity != null) {
				object = (JSONObject) JSONObject.toJSON(databaseEntity);
				Map<String, String> param = DatabaseConfig.load(databaseEntity.getName());
				if (param != null) {
					for (String key : param.keySet()) {
						object.put(key, param.get(key));
					}
				}
			}
		} catch (Exception e) {
			if (object.isEmpty()) {
				throw e;
			}
		}

		Database database = JSON.toJavaObject(object, Database.class);
		Map<String, String> format = DatabaseConfig.loadFormat();
		if (format != null) {
			for (String key : format.keySet()) {
				if (!StringUtil.isEmpty(format.get(key))) {
					String value = format.get(key);
					if (value.indexOf("{name}") >= 0) {
						value = value.replaceAll("\\{name\\}", database.getName());
					}
					if (application != null && application.getAppContext() != null) {
						AppEntity app = application.getAppContext().getApp();
						ProductEntity product = application.getAppContext().getProduct();

						if (app != null) {
							if (value.indexOf("{appname}") >= 0) {
								if (!StringUtil.isEmpty(app.getName())) {
									value = value.replaceAll("\\{appname\\}", app.getName());
								}
							}
							if (value.indexOf("{appid}") >= 0) {
								if (!StringUtil.isEmpty(app.getId())) {
									value = value.replaceAll("\\{appid\\}", app.getId());
								}
							}
							if (value.indexOf("{accountname}") >= 0) {
								if (!StringUtil.isEmpty(app.getAccountname())) {
									value = value.replaceAll("\\{accountname\\}", app.getAccountname());
								}
							}
							if (value.indexOf("{accountcode}") >= 0) {
								if (!StringUtil.isEmpty(app.getAccountcode())) {
									value = value.replaceAll("\\{accountcode\\}", app.getAccountcode());
								}
							}
						}
						if (product != null) {
							if (value.indexOf("{productname}") >= 0) {
								if (!StringUtil.isEmpty(product.getName())) {
									value = value.replaceAll("\\{productname\\}", product.getName());
								}
							}
							if (value.indexOf("{productid}") >= 0) {
								if (!StringUtil.isEmpty(product.getId())) {
									value = value.replaceAll("\\{productid\\}", product.getId());
								}
							}
							if (value.indexOf("{accountname}") >= 0) {
								if (!StringUtil.isEmpty(product.getId())) {
									value = value.replaceAll("\\{accountname\\}", product.getAccountname());
								}
							}
							if (value.indexOf("{accountcode}") >= 0) {
								if (!StringUtil.isEmpty(product.getId())) {
									value = value.replaceAll("\\{accountcode\\}", product.getAccountcode());
								}
							}
						}
					}

					object.put(key, value);

				}
			}
		}

		database = JSON.toJavaObject(object, Database.class);

		String initializeclass = database.getInitializeclass();

		if (!StringUtil.isEmpty(initializeclass)) {
			try {
				Class<?> clazz = Class.forName(initializeclass);
				Object obj = clazz.newInstance();
				if (obj instanceof IDatabaseFormater) {
					IDatabaseFormater formater = (IDatabaseFormater) object;
					formater.format(database);
				} else {
					throw new Exception(clazz + " is not implement " + IDatabaseFormater.class);
				}
			} catch (ExceptionInInitializerError e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return database;
	}

}
