/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.session;

import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import top.coos.app.Application;
import top.coos.factory.LogFactory;

public class AppSession {
    static Logger log = LogFactory.get();
    private final HttpSession session;
    private final Application application;
    private boolean login;
    private String loginAccountId;
    private JSONObject account;
    private JSONObject cache;

    public AppSession(HttpSession session, Application application) {
        this.session = session;
        this.application = application;
        if (application != null) {
            application.triggerNewInstance(this);
        }
    }

    public String getLoginAccountId() {
        return this.loginAccountId;
    }

    public void setLoginAccountId(String loginAccountId) {
        this.loginAccountId = loginAccountId;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void doLogin(JSONObject account) {
        this.account = account;
        this.login = true;
        if (this.application != null) {
            this.application.triggerLogin(this);
        }
    }

    public void doLogout() {
        this.account = null;
        this.login = false;
        if (this.application != null) {
            this.application.triggerLogout(this);
        }
    }

    public JSONObject getAccount() {
        return this.account;
    }

    public Application getApplication() {
        return this.application;
    }

    public JSONObject getCache() {
        return this.cache;
    }

    public void setCache(JSONObject cache) {
        this.cache = cache;
    }
}

