/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.servlet;

import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;
import top.coos.Configuration;
import top.coos.ConfigurationFactory;
import top.coos.app.factory.ApplicationFactory;
import top.coos.app.servlet.AppControlServlet;
import top.coos.app.servlet.AppFilter;
import top.coos.resource.handler.ResourceHandler;
import top.coos.util.StringUtil;

public class AppServletContext {
    public static ServletContext CONTEXT;

    public static void initialize(ServletContext context) {
        if (CONTEXT != null) {
            return;
        }
        if (context == null) {
            throw new RuntimeException("context is null.");
        }
        CONTEXT = context;
        AppServletContext.init();
    }

    private static void init() {
        try {
            AppControlServlet servlet = (AppControlServlet)ResourceHandler.getBean(AppControlServlet.class);
            String name = AppControlServlet.class.getName();
            ServletRegistration.Dynamic appControl = CONTEXT.addServlet(name, (Servlet)((HttpServlet)servlet));
            CONTEXT.setAttribute("APP_CONTROL_SERVLET_REGISTRATION", (Object)appControl);
            AppFilter filter = (AppFilter)ResourceHandler.getBean(AppFilter.class);
            name = AppFilter.class.getName();
            FilterRegistration.Dynamic appFilter = CONTEXT.addFilter(name, (Filter)filter);
            CONTEXT.setAttribute("APP_FILTER_REGISTRATION", (Object)appFilter);
            Configuration configuration = ConfigurationFactory.get();
            if (configuration != null && !StringUtil.isEmpty((CharSequence)configuration.getAppid())) {
                ApplicationFactory.get(CONTEXT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addAppControlRegistration(ServletRegistration registration) {
    }

    private static void validate() {
        if (CONTEXT == null) {
            throw new RuntimeException("app servlet context not initialize.");
        }
    }

    public static ServletRegistration getAppControl() {
        AppServletContext.validate();
        return (ServletRegistration)CONTEXT.getAttribute("APP_CONTROL_SERVLET_REGISTRATION");
    }

    public static FilterRegistration getAppFilter() {
        AppServletContext.validate();
        return (FilterRegistration)CONTEXT.getAttribute("APP_FILTER_REGISTRATION");
    }
}

