/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.factory;

import java.sql.SQLException;
import top.coos.app.Application;
import top.coos.bean.Database;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.db.ds.DSFactory;
import top.coos.service.Service;
import top.coos.service.dynamic.DynamicService;

public class ServiceFactory {
    static final Cache<String, DSFactory> DF_CACHE = CacheUtil.newCache();
    static final Cache<String, Database> DATABASE_CACHE = CacheUtil.newCache();

    private static String getFactoryKey(Database database) {
        String key = "";
        if (database != null) {
            key = key + database.getUrl();
            key = key + "-" + database.getName();
        }
        return key;
    }

    private static String getDatabaseKey(Application application, String name) {
        String key = "";
        if (application.getAppContext() != null && application.getAppContext().getProduct() != null) {
            key = key + application.getAppContext().getProduct().getId();
        }
        key = key + "-" + name;
        return key;
    }

    private static final DSFactory createDSFactory(Database database) throws SQLException {
        DSFactory factory = DSFactory.get((Database)database);
        return factory;
    }

    public static final DSFactory getDSFactory(Database database) throws SQLException {
        String key = ServiceFactory.getFactoryKey(database);
        DSFactory factory = (DSFactory)DF_CACHE.get((Object)key);
        if (factory == null) {
            factory = ServiceFactory.createDSFactory(database);
        }
        DF_CACHE.put((Object)key, (Object)factory);
        return factory;
    }

    public static final DSFactory get(Application application, String name) throws Exception {
        if (application == null) {
            throw new Exception("application is null.");
        }
        String key = ServiceFactory.getDatabaseKey(application, name);
        if (DATABASE_CACHE.get((Object)key) == null) {
            Database database = application.getDatabaseByName(name);
            DATABASE_CACHE.put((Object)key, (Object)database);
        }
        return ServiceFactory.getDSFactory((Database)DATABASE_CACHE.get((Object)key));
    }

    public static final Service getService(Application application, String name) throws Exception {
        return ServiceFactory.getService(ServiceFactory.get(application, name));
    }

    public static final Service getService(Database database) throws SQLException {
        return ServiceFactory.getService(ServiceFactory.getDSFactory(database));
    }

    public static final Service getService(DSFactory factory) {
        return new DynamicService(factory);
    }
}

