package top.coos.app.context;

import java.util.ArrayList;
import java.util.List;

import top.coos.app.Application;
import top.coos.app.entity.AppEntity;
import top.coos.app.entity.Entity;
import top.coos.app.entity.ProductEntity;
import top.coos.app.entity.cache.CacheEntity;
import top.coos.app.entity.control.ControlEntity;
import top.coos.app.entity.database.DatabaseEntity;
import top.coos.app.entity.database.DatabaseTableColumnEntity;
import top.coos.app.entity.database.DatabaseTableEntity;
import top.coos.app.entity.dictionary.DictionaryEntity;
import top.coos.app.entity.menu.MenuEntity;
import top.coos.app.entity.page.PageEntity;
import top.coos.app.entity.plugin.PluginEntity;
import top.coos.app.entity.resource.ResourceEntity;
import top.coos.app.entity.service.ServiceEntity;
import top.coos.app.entity.service.ServiceTemplateEntity;
import top.coos.app.entity.theme.ThemeEntity;
import top.coos.app.factory.ApplicationFactory;
import top.coos.app.plugin.Plugin;
import top.coos.app.plugin.PluginLoader;
import top.coos.util.StringUtil;

public class AppContext {

	public AppContext() {

	}

	private ProductEntity product;

	private AppEntity app;

	private List<ResourceEntity> resources = new ArrayList<ResourceEntity>();

	private List<CacheEntity> caches = new ArrayList<CacheEntity>();

	private List<MenuEntity> menus = new ArrayList<MenuEntity>();

	private List<ThemeEntity> themes = new ArrayList<ThemeEntity>();

	private List<ControlEntity> controls = new ArrayList<ControlEntity>();

	private List<PageEntity> pages = new ArrayList<PageEntity>();

	private List<ServiceEntity> services = new ArrayList<ServiceEntity>();

	private List<ServiceTemplateEntity> service_templates = new ArrayList<ServiceTemplateEntity>();

	private List<DatabaseEntity> databases = new ArrayList<DatabaseEntity>();

	private List<DatabaseTableEntity> tables = new ArrayList<DatabaseTableEntity>();

	private List<DictionaryEntity> dictionarys = new ArrayList<DictionaryEntity>();

	private List<PluginEntity> plugins = new ArrayList<PluginEntity>();

	private List<Plugin> app_plugins = new ArrayList<Plugin>();

	@SuppressWarnings("rawtypes")
	private List getList(Entity entity) {

		if (entity instanceof ThemeEntity) {
			return getThemes();
		} else if (entity instanceof PageEntity) {
			return getPages();
		} else if (entity instanceof ResourceEntity) {
			return getResources();
		} else if (entity instanceof DictionaryEntity) {
			return getDictionarys();
		} else if (entity instanceof CacheEntity) {
			return getCaches();
		} else if (entity instanceof MenuEntity) {
			return getMenus();
		} else if (entity instanceof ControlEntity) {
			return getControls();
		} else if (entity instanceof ServiceEntity) {
			return getServices();
		} else if (entity instanceof ServiceTemplateEntity) {
			return getService_templates();
		} else if (entity instanceof DatabaseEntity) {
			return getDatabases();
		} else if (entity instanceof DatabaseTableEntity) {
			return getTables();
		} else if (entity instanceof PluginEntity) {
			return getPlugins();
		} else if (entity instanceof DatabaseTableColumnEntity) {
			DatabaseTableColumnEntity column = (DatabaseTableColumnEntity) entity;
			if (!StringUtil.isEmpty(column.getTableid())) {
				for (DatabaseTableEntity table : getTables()) {
					if (table.getId().equals(column.getTableid())) {
						return table.getColumns();
					}
				}
			}
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	public AppContext change(Entity entity) {

		if (entity != null) {
			List<Entity> list = (List<Entity>) getList(entity);
			if (list != null) {
				boolean has = false;
				for (int i = 0; i < list.size(); i++) {
					Entity one = (Entity) list.get(i);
					if (one.getId().equals(entity.getId())) {
						has = true;
						list.set(i, entity);
						break;
					}
				}
				if (!has) {
					list.add(entity);
				}
			} else {
				if (entity instanceof AppEntity) {
					app = (AppEntity) entity;
				} else if (entity instanceof ProductEntity) {
					product = (ProductEntity) entity;
				}
			}
			if (getApp() != null) {
				Application application = ApplicationFactory.get(getApp().getId());
				if (application != null) {
					application.triggerChange(entity);
				}
			}
		}

		return this;
	}

	@SuppressWarnings("unchecked")
	public AppContext delete(Entity entity) {

		if (entity != null) {
			List<Entity> list = (List<Entity>) getList(entity);
			if (list != null) {
				for (int i = 0; i < list.size(); i++) {
					Entity one = (Entity) list.get(i);
					if (one.getId().equals(entity.getId())) {
						list.remove(i);
						break;
					}
				}
			}
			if (getApp() != null) {
				Application application = ApplicationFactory.get(getApp().getId());
				if (application != null) {
					application.triggerDelete(entity);
				}
			}
		}

		return this;
	}

	public AppContext initAppPlugins() {

		app_plugins.clear();

		for (PluginEntity plugin : plugins) {
			Plugin app_plugin = PluginLoader.getPlugin(plugin);
			if (app_plugin != null) {
				app_plugins.add(app_plugin);
			}
		}
		return this;
	}

	public AppContext triggerInstallPlugins()
	{

		initAppPlugins();

		if (getApp() != null) {
			Application application = ApplicationFactory.get(getApp().getId());
			if (application != null) {
				application.triggerPluginsChange();
			}
		}
		return this;
	}

	public AppContext triggerUninstallPlugins()
	{

		initAppPlugins();
		if (getApp() != null) {
			Application application = ApplicationFactory.get(getApp().getId());
			if (application != null) {
				application.triggerPluginsChange();
			}
		}
		return this;
	}

	public List<ServiceTemplateEntity> getService_templates() {

		return service_templates;
	}

	public void setService_templates(List<ServiceTemplateEntity> service_templates) {

		this.service_templates = service_templates;
	}

	public ProductEntity getProduct() {

		return product;
	}

	public void setProduct(ProductEntity product) {

		this.product = product;
	}

	public List<ResourceEntity> getResources() {

		return resources;
	}

	public void setResources(List<ResourceEntity> resources) {

		this.resources = resources;
	}

	public List<CacheEntity> getCaches() {

		return caches;
	}

	public void setCaches(List<CacheEntity> caches) {

		this.caches = caches;
	}

	public List<MenuEntity> getMenus() {

		return menus;
	}

	public void setMenus(List<MenuEntity> menus) {

		this.menus = menus;
	}

	public List<ThemeEntity> getThemes() {

		return themes;
	}

	public void setThemes(List<ThemeEntity> themes) {

		this.themes = themes;
	}

	public List<ControlEntity> getControls() {

		return controls;
	}

	public void setControls(List<ControlEntity> controls) {

		this.controls = controls;
	}

	public List<PageEntity> getPages() {

		return pages;
	}

	public void setPages(List<PageEntity> pages) {

		this.pages = pages;
	}

	public List<ServiceEntity> getServices() {

		return services;
	}

	public void setServices(List<ServiceEntity> services) {

		this.services = services;
	}

	public List<DatabaseEntity> getDatabases() {

		return databases;
	}

	public void setDatabases(List<DatabaseEntity> databases) {

		this.databases = databases;
	}

	public List<DatabaseTableEntity> getTables() {

		return tables;
	}

	public void setTables(List<DatabaseTableEntity> tables) {

		if (tables == null) {
			tables = new ArrayList<DatabaseTableEntity>();
		}
		for (DatabaseTableEntity table : tables) {
			if (table.getColumns() == null) {
				table.setColumns(new ArrayList<DatabaseTableColumnEntity>());
			}
		}
		this.tables = tables;
	}

	public List<DictionaryEntity> getDictionarys() {

		return dictionarys;
	}

	public void setDictionarys(List<DictionaryEntity> dictionarys) {

		this.dictionarys = dictionarys;
	}

	public List<PluginEntity> getPlugins() {

		return plugins;
	}

	public void setPlugins(List<PluginEntity> plugins) {

		this.plugins = plugins;
		initAppPlugins();
	}

	public AppEntity getApp() {

		return app;
	}

	public void setApp(AppEntity app) {

		this.app = app;
	}

	public List<Plugin> getApp_plugins() {

		return app_plugins;
	}

}
