package top.coos.app.servlet;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import top.coos.app.Application;
import top.coos.app.context.AppContext;
import top.coos.app.factory.ApplicationFactory;
import top.coos.util.FileUtil;
import top.coos.util.ResourceUtil;
import top.coos.util.StringUtil;

public class AppOutUtil {

	public static void outAppPage(HttpServletRequest request, HttpServletResponse response, String page) {

		if (!StringUtil.isEmpty(page)) {
			ClassLoader loader = null;
			if (!ApplicationFactory.isDev(request.getSession())) {
				try {
					loader = ApplicationFactory.get(request).getClassLoader();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			InputStream stream = ResourceUtil.load(loader, page);
			if (stream != null) {
				StringBuffer body = new StringBuffer();
				body.append(FileUtil.read(stream));

				outAppHTML(request, response, body);
			}
		}
	}

	public static void outAppPage(HttpServletRequest request, HttpServletResponse response, String page, Set<String> css,
			Set<String> jss) {

		if (!StringUtil.isEmpty(page)) {
			ClassLoader loader = null;
			if (!ApplicationFactory.isDev(request.getSession())) {
				try {
					loader = ApplicationFactory.get(request).getClassLoader();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			InputStream stream = ResourceUtil.load(loader, page);
			if (stream != null) {
				StringBuffer body = new StringBuffer();
				body.append(FileUtil.read(stream));

				outAppHTML(request, response, body, css, jss, null);
			}
		}
	}

	public static void outAppHTML(HttpServletRequest request, HttpServletResponse response, StringBuffer body) {

		outAppHTML(request, response, body, null, null, null);
	}

	public static void outAppHTML(HttpServletRequest request, HttpServletResponse response, StringBuffer body,
			Set<String> css, Set<String> jss, StringBuffer script) {

		if (css == null) {
			css = new HashSet<String>();
		}
		if (jss == null) {
			jss = new HashSet<String>();
		}

		try {
			if (!ApplicationFactory.isDev(request.getSession())) {

				Application application = ApplicationFactory.get(request);
				AppContext context = application.getAppContext();

				if (context != null && context.getResources() != null) {

				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		outHTML(request, response, body, css, jss, script);
	}

	private static void outHTML(HttpServletRequest request, HttpServletResponse response, StringBuffer body,
			Set<String> css,
			Set<String> jss, StringBuffer script) {

		String content = request.getServletContext().getContextPath();
		if (StringUtil.isEmpty(content)) {
			content = "/";
		}
		if (content.indexOf("/") != content.length() - 1) {
			content += "/";
		}
		StringBuffer html = new StringBuffer();
		html.append("<!DOCTYPE html>").append("\n");
		html.append("<html>").append("\n");
		html.append("<head lang=\"en\">").append("\n");
		html.append("<meta charset=\"UTF-8\" />").append("\n");
		html.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0 , user-scalable=no\">");
		html.append("\n");
		html.append("<title>COOS</title>").append("\n");
		html.append("<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"" + content
				+ "resources/coos/images/favicon.png\" media=\"screen\" />");
		html.append("\n");
		if (css != null) {
			for (String cs : css) {

				if (!StringUtil.isEmpty(cs)) {
					html.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + content + cs + "\" />");
					html.append("\n");
				}
			}
		}
		html.append("<script type=\"text/javascript\" src=\"" + content + "resources/coos/main.src.js\"></script>");
		html.append("\n");
		html.append("<script type=\"text/javascript\" src=\"" + content + "coos/app/main\"></script>");
		html.append("\n");

		if (jss != null) {
			for (String js : jss) {
				if (!StringUtil.isEmpty(js)) {
					html.append("<script type=\"text/javascript\" src=\"" + content + js + "\"></script>");
					html.append("\n");
				}
			}
		}
		if (!StringUtil.isEmpty(script)) {
			html.append("<script type=\"text/javascript\">");
			html.append("\n");
			html.append(script);
			html.append("\n");
			html.append("</script>");
			html.append("\n");
		}
		html.append("</head>").append("\n");
		html.append("<body>").append("\n");
		html.append("<div id=\"page-body-content\">").append("\n");
		html.append(body).append("\n");
		html.append("<div>").append("\n");
		html.append("</body>").append("\n");
		html.append("</html>").append("\n");

		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/html");
		try {
			response.getWriter().write(html.toString());
			response.getWriter().flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
