package top.coos.app.servlet;

import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;

import top.coos.Configuration;
import top.coos.ConfigurationFactory;
import top.coos.app.factory.ApplicationFactory;
import top.coos.resource.handler.ResourceHandler;
import top.coos.util.StringUtil;

public class AppServletContext {

	public static ServletContext CONTEXT;

	public static void initialize(ServletContext context) {

		if (CONTEXT != null) {
			return;
		}
		if (context == null) {
			throw new RuntimeException("context is null.");
		}
		CONTEXT = context;
		init();
	}

	private static void init() {

		try {
			AppControlServlet servlet = ResourceHandler.getBean(AppControlServlet.class);
			String name = AppControlServlet.class.getName();
			ServletRegistration appControl = CONTEXT.addServlet(name, (HttpServlet) servlet);
			CONTEXT.setAttribute("APP_CONTROL_SERVLET_REGISTRATION", appControl);

			AppFilter filter = ResourceHandler.getBean(AppFilter.class);
			name = AppFilter.class.getName();
			FilterRegistration appFilter = CONTEXT.addFilter(name, (Filter) filter);
			appFilter.addMappingForUrlPatterns(null, true, "/*");
			CONTEXT.setAttribute("APP_FILTER_REGISTRATION", appFilter);

			// 设置AppContext
			Configuration configuration = ConfigurationFactory.get();
			if (configuration != null && !StringUtil.isEmpty(configuration.getAppid())) {
				ApplicationFactory.get(CONTEXT);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void addAppControlRegistration(ServletRegistration registration) {

	}

	private static void validate() {

		if (CONTEXT == null) {
			throw new RuntimeException("app servlet context not initialize.");
		}
	}

	public static ServletRegistration getAppControl() {

		validate();
		return (ServletRegistration) CONTEXT.getAttribute("APP_CONTROL_SERVLET_REGISTRATION");
	}

	public static FilterRegistration getAppFilter() {

		validate();
		return (FilterRegistration) CONTEXT.getAttribute("APP_FILTER_REGISTRATION");
	}

}
