(function() {
	app.role = app.role || new Object();

	var hasUserPlugin = function() {
		return app.source.APP_PLUGIN['USER-1.0'] != null;
	};

	var hasMenuPlugin = function() {
		return app.source.APP_PLUGIN['MENU-1.0'] != null;
	};

	app.role.buildBox = function(options) {
		var setting = {
			size : 'sm',
			url : '/role/queryList.do',
			form : {
				inputs : [ {
					label : '名称',
					name : 'name',
					size : 4
				} ],
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green">搜索</div>',
					isSearch : true
				} ]
			},
			tree : {
				property : {
					id : 'roleid',
					text : 'name',
					pid : 'parentid'
				},
				btns : []
			}
		};

		if (options) {
			if (options.form) {
				$(options.form.btns).each(function(index, btn) {
					setting.form.btns.push(btn);
				});
			}
			$(options.tree.btns).each(function(index, btn) {
				setting.tree.btns.push(btn);
			});
		}
		return coos.buildBox(setting);
	};

	app.role.initIndexPage = function() {
		var build = app.role.buildBox({
			form : {
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-orange mgl-5">添加</div>',
					onClick : function() {
						app.role.initForm('添加');
					}
				} ]
			},
			tree : {
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-orange">修改</div>',
					onClick : function(data) {
						app.role.initForm('编辑', data);
					}
				}, {
					html : '<div class="coos-btn coos-btn-xs coos-red">删除</div>',
					onClick : function(data) {
						coos.box.confirm('删除后该记录将无法恢复，确定删除？', function() {
							coos.post('/role/delete.do', {
								recordid : data.roleid
							}, function(result) {
								result = result || {};
								if (result.errcode == 0) {
								} else {
									coos.box.error(result.errmsg);
								}
								app.role.initIndexPage();
							});
						});
					}
				}, hasUserPlugin() ? {
					html : '<div class="coos-btn coos-btn-xs coos-bg-orange mgl-5">角色用户</div>',
					onClick : function(one) {
						app.role.initUserPage(one.roleid);
					}
				} : null, hasMenuPlugin() ? {
					html : '<div class="coos-btn coos-btn-xs coos-bg-orange mgl-5">角色菜单</div>',
					onClick : function(one) {
						app.role.initMenuPage(one.roleid);
					}
				} : null ]
			}
		});
		$('.role-list-box').empty();
		$('.role-list-box').append(build.$box);
		app.role.initForm('添加');
	};

	app.role.initForm = function(title, data, callback) {
		var $rightBox = $('.for-right-box');
		$rightBox.empty();

		title = title || '编辑';

		var $box = $('<div class=" coos-row" />');
		$rightBox.append($box);

		$box.append('<div class="pd-10 coos-bg-orange"><h4 class="role-form-title">' + title + '</h4></div>');

		var $formBox = $('<div class="coos-row pd-10 coos-bd "></div>');
		$box.append($formBox);

		coos.post('/role/queryList.do', function(result) {

			var $form = $('<div class="coos-form coos-input-sm"/>');
			$formBox.append($form);

			$form.append('<input name="roleid" type="hidden" class="coos-input " />');
			$form.append('<input name="name" required="1" auto-validate="1" input-skin="0" label="名称" class="coos-input " />');
			$form.append('<input name="code" input-skin="0" label="代码" class="coos-input " />');
			$form.append('<input name="cachename" input-skin="0" label="缓存名称（被分配的用户则缓存值为1，否则为0）" class="coos-input " />');
			$form.append('<input name="fordefault" input-skin="0" label="是默认" info="为true则所有用户享受该组" class="coos-input coos-input-switch" />');
			$form.append('<input name="parentid" input-skin="0" label="父级" class="coos-input coos-input-select" />');

			var $select = $('<select class="coos-option-cache"/>');
			$form.append($select);
			$select.append('<option value="">请选择</option>');
			$(result.value).each(function(index, one) {
				if (data && data.roleid == one.roleid) {
					return;
				}
				var $option = $('<option/>');
				$option.text(one.name);
				$option.attr('value', one.roleid);
				$select.append($option);
			});

			$form.append('<input name="sequence" input-skin="0" label="顺序号" class="coos-input " />');

			coos.format.init($form);
			data = data || {};
			data.sequence = data.sequence || 1;
			coos.form.full($form, data, true);

			var $btnBox = $('<div class="coos-row mg-10"/>');

			$formBox.append($btnBox);

			var $btn = $('<div class="coos-btn coos-btn-sm coos-bg-green">保存</div>');
			$btn.click(function() {
				var result = coos.form.validate($form);
				if (result.valid) {
					var data = coos.form.getData($form);
					coos.post('/role/save.do', data, function(result) {
						result = result || {};
						if (result.errcode == 0) {
						} else {
							coos.box.error(result.errmsg);
						}
						app.role.initIndexPage();
					});
				}
			});
			$btnBox.append($btn);
		});
	};

	app.role.initUserPage = function(roleid, callback) {

		var $rightBox = $('.for-right-box');
		$rightBox.empty();

		var $box = $('<div class=" coos-row" />');
		$rightBox.append($box);

		$box.append('<div class="pd-10 coos-bg-orange"><h4 class="role-form-title">用户列表</h4></div>');

		var $userBox = $('<div class="coos-row pd-10 coos-bd "></div>');
		$box.append($userBox);

		var build = coos.buildBox({
			size : 'sm',
			url : '/role/queryUserPage.do?roleid=' + roleid,
			form : {
				inputs : [ {
					label : '姓名',
					name : 'username',
					size : 4
				}, {
					label : '登录名',
					name : 'loginname',
					size : 4
				} ],
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green ">搜索</div>',
					isSearch : true
				}, {
					html : '<div class="coos-btn coos-btn-xs coos-orange mgl-5">添加</div>',
					onClick : function() {
						var build = app.user.buildBox({
							table : {
								cols : [ {
									text : '操作',
									btns : [ {
										html : '<div class="coos-btn coos-btn-xs coos-bg-orange">添加</div>',
										onClick : function(one, $btn, $tr) {
											coos.post('/role/addUser.do', {
												roleid : roleid,
												userid : one.userid
											}, function(result) {
												result = result || {};
												if (result.errcode == 0) {
													$btn.addClass('coos-disabled');
													$btn.html('已添加');
													app.role.initUserPage(roleid, callback);
												} else {
													coos.box.error(result.errmsg);
												}

											});
										}
									} ]
								} ]
							}
						});
						var box = coos.box({
							title : '选择用户添加',
							openMove : true,
							html : build.$box,
							width : 800,
							height : 500,
							onClose : function() {
								box.destroy();
							}
						});
						box.show();
					}
				} ]
			},
			table : {
				cols : [ {
					text : '姓名',
					name : 'username'
				}, {
					text : '登录名',
					name : 'loginname'
				}, {
					text : '操作',
					btns : [ {
						html : '<div class="coos-btn coos-btn-xs coos-red mgl-5">移出</div>',
						onClick : function(data) {
							coos.post('/role/deleteUser.do', {
								roleid : roleid,
								userid : data.userid
							}, function(result) {
								result = result || {};
								if (result.errcode == 0) {
									app.role.initUserPage(roleid, callback);
								} else {
									coos.box.error(result.errmsg);
								}

							});
						}
					} ]
				} ],
				page : true
			}
		});
		$userBox.append(build.$box);
	};

	app.role.initMenuPage = function(roleid, callback) {

		var $rightBox = $('.for-right-box');
		$rightBox.empty();

		var $box = $('<div class=" coos-row" />');
		$rightBox.append($box);

		$box.append('<div class="pd-10 coos-bg-orange"><h4 class="role-form-title">菜单列表</h4></div>');

		var $userBox = $('<div class="coos-row pd-10 coos-bd "></div>');
		$box.append($userBox);

		var build = coos.buildBox({
			size : 'sm',
			url : '/role/queryMenuList.do?roleid=' + roleid,
			form : {
				inputs : [ {
					label : '名称',
					name : 'name',
					size : 4
				} ],
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green ">搜索</div>',
					isSearch : true
				}, {
					html : '<div class="coos-btn coos-btn-xs coos-orange mgl-5">添加</div>',
					onClick : function() {
						var build = app.menu.buildBox({
							tree : {
								btns : [ {
									html : '<div class="coos-btn coos-btn-xs coos-bg-orange">添加</div>',
									onClick : function(one, $tr, $row, $btn) {
										coos.post('/role/addMenu.do', {
											roleid : roleid,
											menuid : one.menuid
										}, function(result) {
											result = result || {};
											if (result.errcode == 0) {
												$btn.addClass('coos-disabled');
												$btn.html('已添加');
												app.role.initMenuPage(roleid, callback);
											} else {
												coos.box.error(result.errmsg);
											}

										});
									}
								} ]
							}
						});
						var box = coos.box({
							title : '选择菜单添加',
							openMove : true,
							html : build.$box,
							width : 800,
							height : 500,
							onClose : function() {
								box.destroy();
							}
						});
						box.show();
					}
				} ]
			},
			tree : {
				property : {
					id : 'menuid',
					text : 'name',
					pid : 'parentid'
				},
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-red mgl-5">移出</div>',
					onClick : function(data) {
						coos.post('/role/deleteUser.do', {
							roleid : roleid,
							userid : data.userid
						}, function(result) {
							result = result || {};
							if (result.errcode == 0) {
								app.role.initUserPage(roleid, callback);
							} else {
								coos.box.error(result.errmsg);
							}

						});
					}
				} ]
			}
		});
		$userBox.append(build.$box);
	};
})();