package top.coos.app.bean;

import java.util.ArrayList;
import java.util.List;

public class InputBean {

	private String name;
	private String label;
	private String type;
	private String info;
	private List<InputOptionBean> options = new ArrayList<InputOptionBean>();

	public InputBean(String name, String label) {

		this.name = name;
		this.label = label;
	}

	public InputBean(String name, String label, String type) {

		this.name = name;
		this.label = label;
		this.type = type;
	}

	public InputBean addOption(InputOptionBean option) {

		if (options == null) {
			options = new ArrayList<InputOptionBean>();
		}
		options.add(option);
		return this;
	}

	public List<InputOptionBean> getOptions() {

		return options;
	}

	public void setOptions(List<InputOptionBean> options) {

		this.options = options;
	}

	public String getName() {

		return name;
	}

	public void setName(String name) {

		this.name = name;
	}

	public String getLabel() {

		return label;
	}

	public void setLabel(String label) {

		this.label = label;
	}

	public String getType() {

		return type;
	}

	public void setType(String type) {

		this.type = type;
	}

	public String getInfo() {

		return info;
	}

	public void setInfo(String info) {

		this.info = info;
	}

}
