(function() {
	app.menu = app.menu || new Object();

	app.menu.buildBox = function(options) {
		var setting = {
			size : 'sm',
			url : '/menu/queryList.do',
			form : {
				inputs : [ {
					label : '名称',
					name : 'name',
					size : 4
				} ],
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green">搜索</div>',
					isSearch : true
				} ]
			},
			tree : {
				property : {
					id : 'menuid',
					text : 'name',
					pid : 'parentid'
				},
				btns : []
			}
		};

		if (options) {
			if (options.form) {
				$(options.form.btns).each(function(index, btn) {
					setting.form.btns.push(btn);
				});
			}
			$(options.tree.btns).each(function(index, btn) {
				setting.tree.btns.push(btn);
			});
		}
		return coos.buildBox(setting);
	};

	app.menu.initIndexPage = function() {

		$('.menu-list-box').empty();

		var build = app.menu.buildBox({
			form : {
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-orange mgl-5">添加</div>',
					onClick : function() {
						app.menu.initForm('添加');
					}
				} ]
			},
			tree : {
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green">添加子组</div>',
					onClick : function(data) {
						app.menu.initForm('编辑', {
							parentid : data.menuid
						});
					}
				}, {
					html : '<div class="coos-btn coos-btn-xs coos-orange">修改</div>',
					onClick : function(data) {
						app.menu.initForm('编辑', data);
					}
				}, {
					html : '<div class="coos-btn coos-btn-xs coos-red mgl-5">删除</div>',
					onClick : function(data) {
						coos.box.confirm('删除后该记录将无法恢复，确定删除？', function() {
							coos.post('/menu/delete.do', {
								recordid : data.menuid
							}, function(result) {
								result = result || {};
								if (result.errcode == 0) {
								} else {
									coos.box.error(result.errmsg);
								}
								app.menu.initIndexPage();
							});
						});
					}
				} ]
			}
		});
		$('.menu-list-box').empty();
		$('.menu-list-box').append(build.$box);
		app.menu.initForm('添加');
	};

	app.menu.initForm = function(title, data, callback) {
		title = title || '编辑';
		$('.menu-form-title').html(title);
		var $box = $('.menu-form-box');
		$box.empty();

		coos.post('/menu/queryList.do', function(result) {
			var $form = $('<div class="coos-form coos-input-sm"/>');
			$box.append($form);

			$form.append('<input name="menuid" type="hidden" class="coos-input " />');
			$form.append('<input name="name" required="1" input-skin="0" label="名称" class="coos-input " />');
			$form.append('<input name="url" input-skin="0" label="地址" class="coos-input " />');
			$form.append('<input name="fornav" input-skin="0" label="用于导航" class="coos-input coos-input-switch" />');
			$form.append('<input name="fonticon" input-skin="0" label="字体图标" class="coos-input " />');
			$form.append('<input name="image" input-skin="0" label="图片" class="coos-input coos-input-file-image" />');
			$form.append('<input name="shouldlogin" input-skin="0" label="需要登录" class="coos-input coos-input-switch" />');
			$form.append('<input name="shouldauthorize" input-skin="0" label="需要授权" class="coos-input coos-input-switch" />');
			$form.append('<input name="parentid" input-skin="0" label="父级" class="coos-input coos-input-select" />');

			var $select = $('<select class="coos-option-cache"/>');
			$form.append($select);
			$select.append('<option value="">请选择</option>');
			$(result.value).each(function(index, one) {
				if (data && data.menuid == one.menuid) {
					return;
				}
				var $option = $('<option/>');
				$option.text(one.name);
				$option.attr('value', one.menuid);
				$select.append($option);
			});
			$form.append('<input name="sequence" input-skin="0" label="顺序号" class="coos-input " />');

			coos.format.init($form);
			data = data || {};
			data.sequence = data.sequence || 1;
			coos.form.full($form, data, true);

			var $btnBox = $('<div class="coos-row mg-10"/>');

			$box.append($btnBox);

			var $btn = $('<div class="coos-btn coos-btn-sm coos-bg-green">保存</div>');
			$btn.click(function() {
				var result = coos.form.validate($form);
				if (result.valid) {
					var data = coos.form.getData($form);
					coos.post('/menu/save.do', data, function(result) {
						result = result || {};
						if (result.errcode == 0) {
						} else {
							coos.box.error(result.errmsg);
						}
						app.menu.initIndexPage();
					});
				}
			});
			$btnBox.append($btn);
		});
	};

})();