/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.coos.app.entity.plugin.PluginEntity;
import top.coos.app.plugin.Plugin;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.util.FileUtil;
import top.coos.util.ResourceUtil;
import top.coos.util.StringUtil;

public class PluginLoader {
    private static final Cache<String, Plugin> APP_PLUGIN_CACHE = CacheUtil.newCache();
    private static final URLClassLoader URL_CLASS_LOADER = new URLClassLoader(new URL[0], PluginLoader.class.getClassLoader());

    public static Map<File, JarFile> loadLocalJarFiles() {
        HashMap<File, JarFile> jarFiles = new HashMap<File, JarFile>();
        try {
            InputStream in = ResourceUtil.load((String)"coos.app.plugin.list");
            BufferedReader bf = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = "";
            while ((line = bf.readLine()) != null) {
                byte[] bytes;
                File file;
                JarFile jarFile;
                String name;
                InputStream stream;
                if (StringUtil.isEmpty((CharSequence)line) || (stream = ResourceUtil.load((String)(name = line.trim()))) == null || (jarFile = PluginLoader.loader(URL_CLASS_LOADER, file = ResourceUtil.tempJar((String)name, (byte[])(bytes = FileUtil.readBytes((InputStream)stream))))) == null) continue;
                jarFiles.put(file, jarFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jarFiles;
    }

    public static JarFile loader(URLClassLoader loader, File jarFile) {
        try {
            if (jarFile != null && jarFile.isFile()) {
                URL url = jarFile.toURI().toURL();
                Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                add.setAccessible(true);
                add.invoke((Object)loader, url);
                return new JarFile(jarFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getKey(String name, String version) {
        return name + "-" + version;
    }

    public static String getKey(PluginEntity plugin) {
        return PluginLoader.getKey(plugin.getName(), plugin.getVersion());
    }

    public static String getKey(Plugin plugin) {
        return PluginLoader.getKey(plugin.getName(), plugin.getVersion());
    }

    public static void loadAppPlugins() {
        APP_PLUGIN_CACHE.clear();
        try {
            Map<File, JarFile> jarFiles = PluginLoader.loadLocalJarFiles();
            for (File file : jarFiles.keySet()) {
                Plugin plugin = PluginLoader.resolvePlugin(file, jarFiles.get(file));
                if (plugin == null) continue;
                APP_PLUGIN_CACHE.put((Object)PluginLoader.getKey(plugin), (Object)plugin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Plugin resolvePlugin(File file, JarFile jarFile) {
        Plugin plugin = null;
        Enumeration<JarEntry> entrys = jarFile.entries();
        while (entrys.hasMoreElements()) {
            String name;
            JarEntry entry = entrys.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
            try {
                String class_name = name.substring(0, name.lastIndexOf(".class")).replaceAll("/", ".");
                Class<?> clazz = URL_CLASS_LOADER.loadClass(class_name);
                if (!Plugin.class.isAssignableFrom(clazz)) continue;
                plugin = (Plugin)clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (plugin != null) {
            plugin.setJarFilePath(file.getAbsolutePath());
            plugin.loader(URL_CLASS_LOADER);
        }
        return plugin;
    }

    public static Plugin getPlugin(PluginEntity plugin) {
        if (APP_PLUGIN_CACHE.size() == 0) {
            PluginLoader.loadAppPlugins();
        }
        String key = PluginLoader.getKey(plugin);
        return (Plugin)APP_PLUGIN_CACHE.get((Object)key);
    }

    public static List<Plugin> getAppPlugins() {
        if (APP_PLUGIN_CACHE.size() == 0) {
            PluginLoader.loadAppPlugins();
        }
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String key : APP_PLUGIN_CACHE.keySet()) {
            plugins.add((Plugin)APP_PLUGIN_CACHE.get((Object)key));
        }
        return plugins;
    }
}

