(function() {
	app.user = app.user || new Object();
	app.user.buildBox = function(options) {
		var setting = {
			size : 'sm',
			url : '/user/queryPage.do',
			form : {
				inputs : [ {
					label : '姓名',
					name : 'username',
					size : 4
				}, {
					label : '登录名',
					name : 'loginname',
					size : 4
				} ],
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green">搜索</div>',
					isSearch : true
				} ]
			},
			table : {
				cols : [ {
					text : '姓名',
					name : 'username'
				}, {
					text : '登录名',
					name : 'loginname'
				} ],
				page : true
			}
		};

		if (options) {
			if (options.form) {
				$(options.form.btns).each(function(index, btn) {
					setting.form.btns.push(btn);
				});
			}
			$(options.table.cols).each(function(index, col) {
				setting.table.cols.push(col);
			});
		}
		return coos.buildBox(setting);
	};
	app.user.initIndexPage = function() {

		var build = app.user.buildBox({
			form : {
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-orange mgl-5">添加</div>',
					onClick : function() {
						app.user.initForm('添加');
					}
				} ]
			},
			table : {
				cols : [ {
					text : '操作',
					btns : [ {
						html : '<div class="coos-btn coos-btn-xs coos-orange ">修改</div>',
						onClick : function(one) {
							app.user.initForm('编辑', one);
						}
					}, {
						html : '<div class="coos-btn coos-btn-xs coos-red mgl-5">删除</div>',
						onClick : function(data) {
							coos.box.confirm('删除后该记录将无法恢复，确定删除？', function() {
								coos.post('/user/delete.do', {
									recordid : data.userid
								}, function(result) {
									result = result || {};
									if (result.errcode == 0) {
									} else {
										coos.box.error(result.errmsg);
									}
									app.user.initIndexPage();
								});
							});
						}
					} ]
				} ]
			}
		});
		$('.user-list-box').empty();
		$('.user-list-box').append(build.$box);
		app.user.initForm('添加');
	};

	app.user.initForm = function(title, data, callback) {
		title = title || '编辑';
		$('.user-form-title').html(title);
		var $box = $('.user-form-box');
		$box.empty();

		var $form = $('<div class="coos-form coos-input-sm"/>');
		$box.append($form);

		$form.append('<input name="userid" type="hidden" class="coos-input " />');
		$form.append('<input name="username" required="1" input-skin="0" label="用户名称" info="此用于展示" class="coos-input " />');
		$form.append('<input name="loginname" required="1" input-skin="0" label="登录名称" info="此用于登录" class="coos-input " />');
		$form.append('<input name="image" input-skin="0" label="图片" class="coos-input coos-input-file-image " />');
		$form.append('<input name="phone" input-skin="0" label="手机号" class="coos-input " />');
		$form.append('<input name="email" input-skin="0" label="邮箱" class="coos-input " />');

		coos.format.init($form);

		coos.form.full($form, data, true);

		var $btnBox = $('<div class="coos-row mg-10"/>');

		$box.append($btnBox);

		var $btn = $('<div class="coos-btn coos-btn-sm coos-bg-green">保存</div>');
		$btn.click(function() {
			var result = coos.form.validate($form);
			if (result.valid) {
				var data = coos.form.getData($form);
				coos.post('/user/save.do', data, function(result) {
					result = result || {};
					if (result.errcode == 0) {
					} else {
						coos.box.error(result.errmsg);
					}
					app.user.initIndexPage();
				});
			}
		});
		$btnBox.append($btn);
	};

	app.user.createPageBox = function(options) {
		var setting = {
			size : 'sm',
			form : {},

			url : '/user/queryPage.do',
		};
		if (options) {
			if (options.form) {
				$(options.form.btns).each(function(index, btn) {
					setting.form.btns.push(btn);
				});
			}
			$(options.cols).each(function(index, col) {
				setting.cols.push(col);
			});
		}
		var $box = coos.table.build(setting);
		return $box;
	};
})();