package top.coos.app.configuration;

import com.alibaba.fastjson.JSONObject;

import top.coos.Configuration;

public final class SourceConfiguration extends Configuration {

	static final SourceConfiguration SOURCE_CONFIGURATION = new SourceConfiguration();

	public static SourceConfiguration get() {

		return SOURCE_CONFIGURATION;
	}

	public SourceConfiguration() {

		super();
		initData();
	}

	public void initData() {

		if (this.properties.get("source") != null) {
			source = JSONObject.parseObject(JSONObject.toJSONString(this.properties.get("source")), Source.class);
		}
	}

	public static void main(String[] args) {

		new SourceConfiguration();
	}

	private Source source = new Source();

	public static class Source {

		private String type;

		private Elasticsearch elasticsearch = new Elasticsearch();

		public static class Elasticsearch {

			private String clusterName;

			private String host;

			private String port;

			public String getClusterName() {

				return clusterName;
			}

			public void setClusterName(String clusterName) {

				this.clusterName = clusterName;
			}

			public String getHost() {

				return host;
			}

			public void setHost(String host) {

				this.host = host;
			}

			public String getPort() {

				return port;
			}

			public void setPort(String port) {

				this.port = port;
			}

		}

		public String getType() {

			return type;
		}

		public void setType(String type) {

			this.type = type;
		}

		public Elasticsearch getElasticsearch() {

			return elasticsearch;
		}

		public void setElasticsearch(Elasticsearch elasticsearch) {

			this.elasticsearch = elasticsearch;
		}

	}

	public Source getSource() {

		return source;
	}

	public void setSource(Source source) {

		this.source = source;
	}

}
