/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.session;

import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import top.coos.app.Application;
import top.coos.app.bean.UserBean;
import top.coos.factory.LogFactory;

public class AppSession {
    static Logger log = LogFactory.get();
    private final HttpSession session;
    private final Application application;
    private boolean login;
    private UserBean user;
    private final JSONObject cache = new JSONObject();

    public AppSession(HttpSession session, Application application) {
        this.session = session;
        this.application = application;
        if (application != null) {
            application.triggerNewSession(this);
        }
    }

    public HttpSession getSession() {
        return this.session;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void doLogin(UserBean user) {
        this.user = user;
        this.login = true;
        if (user != null && this.application != null) {
            this.application.triggerLogin(this);
        }
    }

    public void doLogout() {
        this.user = null;
        this.login = false;
        if (this.application != null) {
            this.application.triggerLogout(this);
        }
    }

    public UserBean getUser() {
        return this.user;
    }

    public Application getApplication() {
        return this.application;
    }

    public JSONObject getCache() {
        return this.cache;
    }

    public void set(String key, Object value) {
        this.cache.put(key, value);
    }

    public Object get(String key) {
        return this.cache.get((Object)key);
    }
}

