package top.coos.app.session;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;

import com.alibaba.fastjson.JSONObject;

import top.coos.app.Application;
import top.coos.app.bean.UserBean;
import top.coos.factory.LogFactory;

public class AppSession {

	static Logger log = LogFactory.get();

	private final HttpSession session;

	private final Application application;

	private boolean login;

	private UserBean user;

	private final JSONObject cache = new JSONObject();

	public AppSession(HttpSession session, Application application) {

		this.session = session;
		this.application = application;

		if (application != null) {
			application.triggerNewSession(this);
		}
	}

	public HttpSession getSession() {

		return session;
	}

	public boolean isLogin() {

		return login;
	}

	public void doLogin(UserBean user) {

		this.user = user;
		this.login = true;

		if (user != null && application != null) {
			application.triggerLogin(this);
		}
	}

	public void doLogout() {

		this.user = null;
		this.login = false;
		if (application != null) {
			application.triggerLogout(this);
		}
	}

	public UserBean getUser() {

		return user;
	}

	public Application getApplication() {

		return application;
	}

	public JSONObject getCache() {

		return cache;
	}

	public void set(String key, Object value) {

		this.cache.put(key, value);
	}

	public Object get(String key) {

		return cache.get(key);
	}

}
