package top.coos.app.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import top.coos.app.Application;
import top.coos.app.factory.ApplicationFactory;

public class AppSessionHandler {

	public static AppSession get(HttpServletRequest request) {

		return get(request.getSession());
	}

	public static String getSessionKey(Application application) {

		String key = "APP_SESSION_KEY";
		if (application != null && application.getAppContext() != null) {
			if (application.getAppContext().getApp() != null) {
				key += "_" + application.getAppContext().getApp().getId();
			}
		}
		return key;
	}

	public static AppSession get(HttpSession session) {

		Application application = null;
		try {
			application = ApplicationFactory.get(session);
		} catch (Exception e) {
			e.printStackTrace();
		}
		AppSession appSession = null;
		String key = getSessionKey(application);
		if (session.getAttribute(key) != null) {
			appSession = (AppSession) session.getAttribute(key);
		}
		if (appSession == null) {
			appSession = new AppSession(session, application);
			session.setAttribute(key, appSession);
		}
		return appSession;
	}

	public static void remove(HttpSession session) {

		Application application = null;
		try {
			application = ApplicationFactory.get(session);
		} catch (Exception e) {
			e.printStackTrace();
		}
		String key = getSessionKey(application);
		session.removeAttribute(key);
	}
}
