/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.factory;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import top.coos.Configuration;
import top.coos.ConfigurationFactory;
import top.coos.app.Application;
import top.coos.app.source.Source;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.resource.handler.ResourceHandler;

public class ApplicationFactory {
    static final Cache<String, Application> CACHE_APPLICATION = CacheUtil.newTimedCache((long)0L);
    static final String IS_DEV_SESSION_CACHE_NAME = "IS_DEV_SESSION_CACHE_NAME";
    static final String APPLICATION_SESSION_CACHE_NAME = "APPLICATION_SESSION_CACHE_NAME";
    static final String APPLICATION_CONTEXT_CACHE_NAME = "APPLICATION_CONTEXT_CACHE_NAME";
    static final Object LOCK = new Object();

    public static final Application get(String appid) {
        return (Application)CACHE_APPLICATION.get((Object)appid);
    }

    public static final Application create(Configuration configuration, Source source) throws Exception {
        String appid = configuration.getAppid();
        Application application = (Application)ResourceHandler.getBean(Application.class);
        application.init(configuration, source);
        CACHE_APPLICATION.put((Object)appid, (Object)application);
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Application getCache(Configuration configuration, Source source) throws Exception {
        String appid = configuration.getAppid();
        Application application = (Application)CACHE_APPLICATION.get((Object)appid);
        if (application == null) {
            Object object = LOCK;
            synchronized (object) {
                application = (Application)CACHE_APPLICATION.get((Object)appid);
                if (application == null) {
                    application = ApplicationFactory.create(configuration, source);
                }
            }
        }
        return application;
    }

    public static final Application get() throws Exception {
        return ApplicationFactory.get(ConfigurationFactory.get());
    }

    public static final Application get(Source source) throws Exception {
        return ApplicationFactory.get(ConfigurationFactory.get(), source);
    }

    public static final Application get(Configuration configuration) throws Exception {
        return ApplicationFactory.get(configuration, null);
    }

    public static final Application get(Configuration configuration, Source source) throws Exception {
        return ApplicationFactory.getCache(configuration, source);
    }

    public static final Application get(HttpServletRequest request) throws Exception {
        return ApplicationFactory.get(request.getSession());
    }

    public static final Application get(HttpSession session) throws Exception {
        Application application = null;
        if (session != null) {
            if (session.getAttribute(APPLICATION_SESSION_CACHE_NAME) != null) {
                application = (Application)session.getAttribute(APPLICATION_SESSION_CACHE_NAME);
            }
            if (application == null) {
                application = ApplicationFactory.get(session.getServletContext());
                session.setAttribute(APPLICATION_SESSION_CACHE_NAME, (Object)application);
            }
        } else {
            application = ApplicationFactory.get();
        }
        return application;
    }

    public static final boolean isDev(HttpSession session) {
        return session.getAttribute(IS_DEV_SESSION_CACHE_NAME) != null;
    }

    public static final void setDev(HttpSession session) {
        session.setAttribute(IS_DEV_SESSION_CACHE_NAME, (Object)true);
    }

    public static final boolean has(HttpSession session) {
        return session.getAttribute(APPLICATION_SESSION_CACHE_NAME) != null;
    }

    public static final void cacheToSession(HttpSession session, Application application) {
        session.setAttribute(APPLICATION_SESSION_CACHE_NAME, (Object)application);
    }

    public static final Application get(ServletContext context) throws Exception {
        Application application = null;
        if (context != null) {
            if (context.getAttribute(APPLICATION_CONTEXT_CACHE_NAME) != null) {
                application = (Application)context.getAttribute(APPLICATION_CONTEXT_CACHE_NAME);
            }
            if (application == null) {
                application = ApplicationFactory.get();
                application.initContext();
                context.setAttribute(APPLICATION_CONTEXT_CACHE_NAME, (Object)application);
            }
        } else {
            application = ApplicationFactory.get();
        }
        return application;
    }
}

