/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import top.coos.app.Application;
import top.coos.app.factory.ApplicationFactory;
import top.coos.app.session.AppSession;

public class AppSessionHandler {
    public static AppSession get(HttpServletRequest request) {
        return AppSessionHandler.get(request.getSession());
    }

    public static String getSessionKey(Application application) {
        String key = "APP_SESSION_KEY";
        if (application != null && application.getAppContext() != null && application.getAppContext().getApp() != null) {
            key = key + "_" + application.getAppContext().getApp().getId();
        }
        return key;
    }

    public static AppSession get(HttpSession session) {
        Application application = null;
        try {
            application = ApplicationFactory.get(session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AppSession appSession = null;
        String key = AppSessionHandler.getSessionKey(application);
        if (session.getAttribute(key) != null) {
            appSession = (AppSession)session.getAttribute(key);
        }
        if (appSession == null) {
            appSession = new AppSession(session, application);
            session.setAttribute(key, (Object)appSession);
        }
        return appSession;
    }

    public static void remove(HttpSession session) {
        Application application = null;
        try {
            application = ApplicationFactory.get(session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String key = AppSessionHandler.getSessionKey(application);
        session.removeAttribute(key);
    }
}

