package top.coos.app.factory;

import java.sql.SQLException;

import top.coos.app.Application;
import top.coos.bean.Database;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.db.ds.DSFactory;
import top.coos.service.Service;
import top.coos.service.dynamic.DynamicService;

public class ServiceFactory {

	final static Cache<String, Database> DATABASE_CACHE = CacheUtil.newCache();

	private static String getDatabaseKey(Application application, String name) {

		String key = "";
		if (application.getProductId() != null) {
			key += application.getProductId();
		}
		key += "-" + name;
		return key;
	}

	public static final DSFactory get(Application application, String name) throws Exception {

		if (application == null) {
			throw new Exception("application is null.");
		}
		String key = getDatabaseKey(application, name);
		if (DATABASE_CACHE.get(key) == null) {
			Database database = application.getDatabaseByName(name);
			DATABASE_CACHE.put(key, database);
		}
		return DSFactory.get(DATABASE_CACHE.get(key));
	}

	public static final Service getService(Application application, String name) throws Exception {

		return getService(get(application, name));
	}

	public static final Service getService(Database database) throws SQLException {

		return getService(DSFactory.get(database));
	}

	public static final Service getService(DSFactory factory) {

		return new DynamicService(factory);
	}

}
