package top.coos.app.source;

import java.util.List;
import java.util.Map;

import top.coos.app.context.AppContext;

public interface Source {

	public AppContext load(String appid);

	public <T> T queryOne(String id, Class<T> clazz);

	public <T> List<T> queryList(Map<String, Object> where, Class<T> clazz);

	public <T> List<T> queryList(SourceQueryParam param, Class<T> clazz);

	public <T> List<T> queryPage(Map<String, Object> where, Class<T> clazz, int pageindex, int pagesize);

	public <T> List<T> queryPage(SourceQueryParam param, Class<T> clazz, int pageindex, int pagesize);

	public long queryCount(SourceQueryParam param, Class<?> clazz);

	public boolean save(AppContext context);

	public boolean save(byte[] bytes);

	public byte[] out(AppContext context);

}
