/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.context;

import java.util.ArrayList;
import java.util.List;
import top.coos.app.Application;
import top.coos.app.entity.AppEntity;
import top.coos.app.entity.Entity;
import top.coos.app.entity.ProductEntity;
import top.coos.app.entity.cache.CacheEntity;
import top.coos.app.entity.control.ControlEntity;
import top.coos.app.entity.database.DatabaseEntity;
import top.coos.app.entity.database.DatabaseTableColumnEntity;
import top.coos.app.entity.database.DatabaseTableEntity;
import top.coos.app.entity.dictionary.DictionaryEntity;
import top.coos.app.entity.page.PageEntity;
import top.coos.app.entity.plugin.PluginEntity;
import top.coos.app.entity.resource.ResourceEntity;
import top.coos.app.entity.service.ServiceEntity;
import top.coos.app.entity.service.ServiceTemplateEntity;
import top.coos.app.entity.theme.ThemeEntity;
import top.coos.app.factory.ApplicationFactory;
import top.coos.app.plugin.Plugin;
import top.coos.app.plugin.PluginLoader;
import top.coos.util.StringUtil;

public class AppContext {
    private ProductEntity product;
    private AppEntity app;
    private List<ResourceEntity> resources = new ArrayList<ResourceEntity>();
    private List<CacheEntity> caches = new ArrayList<CacheEntity>();
    private List<ThemeEntity> themes = new ArrayList<ThemeEntity>();
    private List<ControlEntity> controls = new ArrayList<ControlEntity>();
    private List<PageEntity> pages = new ArrayList<PageEntity>();
    private List<ServiceEntity> services = new ArrayList<ServiceEntity>();
    private List<ServiceTemplateEntity> service_templates = new ArrayList<ServiceTemplateEntity>();
    private List<DatabaseEntity> databases = new ArrayList<DatabaseEntity>();
    private List<DatabaseTableEntity> tables = new ArrayList<DatabaseTableEntity>();
    private List<DictionaryEntity> dictionarys = new ArrayList<DictionaryEntity>();
    private List<PluginEntity> plugins = new ArrayList<PluginEntity>();
    private List<Plugin> app_plugins = new ArrayList<Plugin>();

    private List getList(Entity entity) {
        DatabaseTableColumnEntity column;
        if (entity instanceof ThemeEntity) {
            return this.getThemes();
        }
        if (entity instanceof PageEntity) {
            return this.getPages();
        }
        if (entity instanceof ResourceEntity) {
            return this.getResources();
        }
        if (entity instanceof DictionaryEntity) {
            return this.getDictionarys();
        }
        if (entity instanceof CacheEntity) {
            return this.getCaches();
        }
        if (entity instanceof ControlEntity) {
            return this.getControls();
        }
        if (entity instanceof ServiceEntity) {
            return this.getServices();
        }
        if (entity instanceof ServiceTemplateEntity) {
            return this.getService_templates();
        }
        if (entity instanceof DatabaseEntity) {
            return this.getDatabases();
        }
        if (entity instanceof DatabaseTableEntity) {
            return this.getTables();
        }
        if (entity instanceof PluginEntity) {
            return this.getPlugins();
        }
        if (entity instanceof DatabaseTableColumnEntity && !StringUtil.isEmpty((CharSequence)(column = (DatabaseTableColumnEntity)entity).getTableid())) {
            for (DatabaseTableEntity table : this.getTables()) {
                if (!table.getId().equals(column.getTableid())) continue;
                return table.getColumns();
            }
        }
        return null;
    }

    public AppContext onChange(Entity entity) {
        if (entity != null) {
            Application application;
            List list = this.getList(entity);
            if (list != null) {
                boolean has = false;
                for (int i = 0; i < list.size(); ++i) {
                    Entity one = (Entity)list.get(i);
                    if (!one.getId().equals(entity.getId())) continue;
                    has = true;
                    list.set(i, entity);
                    break;
                }
                if (!has) {
                    list.add(entity);
                }
            } else if (entity instanceof AppEntity) {
                this.app = (AppEntity)entity;
            } else if (entity instanceof ProductEntity) {
                this.product = (ProductEntity)entity;
            }
            if (this.getApp() != null && (application = ApplicationFactory.get(this.getApp().getId())) != null) {
                application.triggerChange(entity);
            }
        }
        return this;
    }

    public AppContext onDelete(Entity entity) {
        if (entity != null) {
            Application application;
            List list = this.getList(entity);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity one = (Entity)list.get(i);
                    if (!one.getId().equals(entity.getId())) continue;
                    list.remove(i);
                    break;
                }
            }
            if (this.getApp() != null && (application = ApplicationFactory.get(this.getApp().getId())) != null) {
                application.triggerDelete(entity);
            }
        }
        return this;
    }

    public AppContext initAppPlugins() {
        this.app_plugins.clear();
        for (PluginEntity plugin : this.plugins) {
            Plugin app_plugin = PluginLoader.getPlugin(plugin);
            if (app_plugin == null) continue;
            this.app_plugins.add(app_plugin);
        }
        return this;
    }

    public AppContext triggerInstallPlugins() {
        Application application;
        this.initAppPlugins();
        if (this.getApp() != null && (application = ApplicationFactory.get(this.getApp().getId())) != null) {
            application.triggerPluginsChange();
        }
        return this;
    }

    public AppContext triggerUninstallPlugins() {
        Application application;
        this.initAppPlugins();
        if (this.getApp() != null && (application = ApplicationFactory.get(this.getApp().getId())) != null) {
            application.triggerPluginsChange();
        }
        return this;
    }

    public List<ServiceTemplateEntity> getService_templates() {
        return this.service_templates;
    }

    public void setService_templates(List<ServiceTemplateEntity> service_templates) {
        this.service_templates = service_templates;
    }

    public ProductEntity getProduct() {
        return this.product;
    }

    public void setProduct(ProductEntity product) {
        this.product = product;
    }

    public List<ResourceEntity> getResources() {
        return this.resources;
    }

    public void setResources(List<ResourceEntity> resources) {
        this.resources = resources;
    }

    public List<CacheEntity> getCaches() {
        return this.caches;
    }

    public void setCaches(List<CacheEntity> caches) {
        this.caches = caches;
    }

    public List<ThemeEntity> getThemes() {
        return this.themes;
    }

    public void setThemes(List<ThemeEntity> themes) {
        this.themes = themes;
    }

    public List<ControlEntity> getControls() {
        return this.controls;
    }

    public void setControls(List<ControlEntity> controls) {
        this.controls = controls;
    }

    public List<PageEntity> getPages() {
        return this.pages;
    }

    public void setPages(List<PageEntity> pages) {
        this.pages = pages;
    }

    public List<ServiceEntity> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceEntity> services) {
        this.services = services;
    }

    public List<DatabaseEntity> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<DatabaseEntity> databases) {
        this.databases = databases;
    }

    public List<DatabaseTableEntity> getTables() {
        return this.tables;
    }

    public void setTables(List<DatabaseTableEntity> tables) {
        if (tables == null) {
            tables = new ArrayList<DatabaseTableEntity>();
        }
        for (DatabaseTableEntity table : tables) {
            if (table.getColumns() != null) continue;
            table.setColumns(new ArrayList<DatabaseTableColumnEntity>());
        }
        this.tables = tables;
    }

    public List<DictionaryEntity> getDictionarys() {
        return this.dictionarys;
    }

    public void setDictionarys(List<DictionaryEntity> dictionarys) {
        this.dictionarys = dictionarys;
    }

    public List<PluginEntity> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<PluginEntity> plugins) {
        this.plugins = plugins;
        this.initAppPlugins();
    }

    public AppEntity getApp() {
        return this.app;
    }

    public void setApp(AppEntity app) {
        this.app = app;
    }

    public List<Plugin> getApp_plugins() {
        return this.app_plugins;
    }
}

